package com.cku.oa.statistics.strategy;

import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.statistics.entity.SaPaymentDetail;
import com.cku.oa.statistics.service.SaPaymentDetailService;
import com.thinkgem.jeesite.common.utils.StringUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public class SplitYearToMonthStrategy implements InitSplitStrategy {
    private SaPaymentDetailService saPaymentDetailService;
    private HashMap<String,RelationShipEntity> relationShipMap;
    private HashMap<String,BigDecimal> chargingPriceMap;
    private int step =12;

    public SplitYearToMonthStrategy(SaPaymentDetailService saPaymentDetailService, HashMap<String,RelationShipEntity> relationShipMap, HashMap<String,BigDecimal> chargingPriceMap,int step) {
        this.saPaymentDetailService = saPaymentDetailService;
        this.relationShipMap =relationShipMap;
        this.chargingPriceMap = chargingPriceMap;
        this.step =step;
    }

    @Override
    public void initSplitOrderDetail(List<PaymentOrderDetail> orderDetailList, String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        orderDetailList.forEach( r ->{
            List<YearToMonthSplitEntity> list = YearToMonthSplitUtils.splitYearToMonth(r.getSplitBeginDate(),step,new BigDecimal(r.getTotalPrice()),new BigDecimal(r.getPrice()));
            for(YearToMonthSplitEntity ytm : list) {
                SaPaymentDetail saDetail = new SaPaymentDetail();
                saDetail.setPaymentNum(Integer.valueOf(r.getNum()));
                saDetail.setMemberCode(r.getMemberCode());
                saDetail.setChargeDate(ytm.getChargeDate());
                saDetail.setMemberCode(r.getMemberCode());
                saDetail.setPrice(ytm.getPrice());
                saDetail.setRunningNumber(r.getOrderCode());
                saDetail.setPaymentMoney(ytm.getPaymentMoney());
                if(relationShipEntity.getCab()!=null && relationShipEntity.getCab().length()>0){
                    saDetail.setType(PAYMENT_TYPE_CAB);
                    saDetail.setChargeItemId(relationShipEntity.getCab());
                } else {
                    saDetail.setType(PAYMENT_TYPE_CKU);
                    saDetail.setChargeItemId(relationShipEntity.getCku());
                }
                saDetail.setSourceCharge(id);
                saDetail.setOrderId(r.getId());
                saDetail.setPaymentTime((r.getPaymentOrder()!=null &&r.getPaymentOrder().getPaymentTime()!=null)?r.getPaymentOrder().getPaymentTime():r.getAddTime());
                saDetail.setDeptId(relationShipEntity.getDept());
                saDetail.setInstallmentEndDate(ytm.getInstallmentEndDate());
                saDetail.setInstallmentBeginDate(ytm.getInstallmentBeginDate());
                saPaymentDetailService.save(saDetail);
            }
        });
    }

    @Override
    public void initSplitRecord(List<PaymentRecord> recordList, String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        recordList.forEach( r ->{
            List<YearToMonthSplitEntity> list = null;
            //如果不是扣费输入分摊区间，走正常拆分 按支付时间向后拆分
            if(StringUtils.isBlank(r.getIsInstallment()) || "0".equals(r.getIsInstallment())){
                list = YearToMonthSplitUtils.splitYearToMonth(r.getSplitBeginDate(),step,new BigDecimal(r.getPaymentAmount()),new BigDecimal(r.getPrice()));
            }else{
                //如果输入分摊区间，走新规拆分 按支付时间 和 拆分时间做对比
                list = YearToMonthSplitUtils.splitYearToMonthWithInstallment(r.getSplitBeginDate(),r.getInstallmentStartDate(),r.getInstallmentEndDate(),step,new BigDecimal(r.getPaymentAmount()),new BigDecimal(r.getPrice()));
            }

            for(YearToMonthSplitEntity ytm : list){
                SaPaymentDetail saDetail = new SaPaymentDetail();
                saDetail.setPaymentNum(r.getChargingItemNum()==null?1:Integer.valueOf(r.getChargingItemNum()));
                saDetail.setMemberCode(r.getMemberCode());
                saDetail.setChargeDate(ytm.getChargeDate());
                saDetail.setPrice(ytm.getPrice());
                saDetail.setRunningNumber(r.getRunningNumber());
                saDetail.setPaymentMoney(ytm.getPaymentMoney());
                if(relationShipEntity.getCab()!=null && relationShipEntity.getCab().length()>0){
                    saDetail.setType(PAYMENT_TYPE_CAB);
                    saDetail.setChargeItemId(relationShipEntity.getCab());
                }else{
                    saDetail.setType(PAYMENT_TYPE_CKU);
                    saDetail.setChargeItemId(relationShipEntity.getCku());
                }
                saDetail.setSourceCharge(id);
                saDetail.setRecordId(r.getId());
                saDetail.setPaymentTime(r.getPaymentTime());
                saDetail.setDeptId(relationShipEntity.getDept());
                saDetail.setInstallmentBeginDate(ytm.getInstallmentBeginDate());
                saDetail.setInstallmentEndDate(ytm.getInstallmentEndDate());
                saPaymentDetailService.save(saDetail);
            }

        });
    }

}
