/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import com.cku.oa.dog.entity.Dog;
import com.cku.oa.show.entity.ChampionLogin;
import com.cku.oa.show.entity.ShowResults;
import com.cku.restful.v1.show.model.CkuChampionLogin;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 冠军登录DAO接口
 * 
 * @author zhuoHeng
 * @version 2016-07-14
 */
@MyBatisDao
public interface ChampionLoginDao extends CrudDao<ChampionLogin> {

	List<ChampionLogin> getByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);
	
	int listCount(ChampionLogin championLogin);

	public Dog getDogMessage(String pedigreeCertified);
	
	public int getCCMessage(String pedigreeCertified);
	public int getJCCMessage(String pedigreeCertified);

	public void resetPrintState(ChampionLogin championLogin);

	/**
	 * 
	 * @Description：验证是否完成了普通登录
	 * @author: zhuoHeng
	 * @version: 2016年8月29日 上午9:59:11
	 */
	public List<ChampionLogin> validateLoginType(@Param("pedigreeCertified") String pedigreeCertified);

	/**
	 * 
	 * @Description：验证登录申请是否重复
	 * @author: zhuoHeng
	 * @version: 2016年8月29日 下午1:59:49
	 */
	public List<ChampionLogin> validateLogin(@Param("loginType") String loginType,
			@Param("pedigreeCertified") String pedigreeCertified);

	void print(ChampionLogin championLogin);

	/**
	 * 
	 * @Description：根据冠军登录类型、血统证书号分页查询登录犬只信息（CKU官网使用） @author: zhuoHeng
	 * @version: 2016年9月23日 下午4:25:42
	 */
	List<CkuChampionLogin> getChampionLogin(@Param("loginType") String loginType,
			@Param("pedigreeCertifiedCode") String pedigreeCertifiedCode, @Param("reviewState") String reviewState,
			@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	Long getChampionLoginCount(@Param("loginType") String loginType,
			@Param("pedigreeCertifiedCode") String pedigreeCertifiedCode, @Param("reviewState") String reviewState);

	/**
	 * 
	 * @Description：按年度查询冠军登录的犬只+图片+犬舍信息
	 * @author: zhuoHeng
	 * @version: 2016年9月23日 下午6:06:35
	 */
	List<CkuChampionLogin> championLogin(@Param("loginType") String loginType, @Param("pageNo") Integer pageNo,
			@Param("pageSize") Integer pageSize, @Param("annual") String annual);

	Long championLoginCount(@Param("loginType") String loginType, @Param("annual") String annual);

	/**
	 * 
	 * @Description：按血统证书号查询冠军登录类别
	 * @author: Jack Xu
	 * @version: 2016年11月17日 下午7:06:35
	 */
	String championLoginType(@Param("pedigreeCertified") String pedigreeCertified);

	int countCC(@Param("pedigreeCertified") String pedigreeCertified);
	
	List<ShowResults> countResult(@Param("pedigreeCertified") String pedigreeCertified);

	int countRCC(@Param("pedigreeCertified") String pedigreeCertified);

	int countJCC(@Param("pedigreeCertified") String pedigreeCertified);

	int countRJCC(@Param("pedigreeCertified") String pedigreeCertified);

	int countBOB_BOS_BOW_BOJ_JBOS(@Param("pedigreeCertified") String pedigreeCertified);

	int countBOB_BOS_BOW(@Param("pedigreeCertified") String pedigreeCertified);

	int countBOB(@Param("pedigreeCertified") String pedigreeCertified);

	int countBIG(@Param("pedigreeCertified") String pedigreeCertified);

	/**
	 * @Description： 查询BIG1的数量
	 * 
	 * @author: yuanshuai
	 * @date: 2019/2/28 14:31
	 */
	int countBIGOne(@Param("pedigreeCertified") String pedigreeCertified);

	int countBIS(@Param("pedigreeCertified") String pedigreeCertified);

	int countCACIB(@Param("pedigreeCertified") String pedigreeCertified);

	// 根据血统证书号查询记录数量
	int countByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);

	// 根据血统证书号查询有效冠军登录信息
	List<String> getLoginTypeByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);

	/**
	 * @description: 根据父犬血统证书号查询子代不同的冠军登录类型的数量
	 * @author: laiguanglong
	 * @date: 2017/10/11 16:34
	 */
	@MapKey("loginType")
	HashMap<String, Map<String, Object>> getChildLoginTypeCountMapByFdogPedigreeCertified(
			@Param("fdogPedigreeCertified") String fdogPedigreeCertified);

	void refundShowChampionLogin(@Param("vo") ChampionLogin vo, @Param("ids") Set<String> ids);

	int countGCC(@Param("pedigreeCertified") String pedigreeCertified);
	int countGCCGroup(@Param("pedigreeCertified") String pedigreeCertified);
}