package com.cku.oa.shop.service;

import java.io.IOException;
import java.util.List;

import com.cku.core.ZAException;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.shop.entity.ShopSaleChannel;
import com.cku.oa.shop.dao.ShopSaleChannelDao;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 商品销售渠道Service
 * @author lyy
 * @version 2016-08-15
 */
@Service
@Transactional(readOnly = true)
public class ShopSaleChannelService extends CrudService<ShopSaleChannelDao, ShopSaleChannel> {


	public ShopSaleChannel get(String id) {
		return super.get(id);
	}
	
	public List<ShopSaleChannel> findList(ShopSaleChannel shopSaleChannel) {
		return super.findList(shopSaleChannel);
	}
	
	public Page<ShopSaleChannel> findPage(Page<ShopSaleChannel> page, ShopSaleChannel shopSaleChannel) {
		return super.findPage(page, shopSaleChannel);
	}
	
	@Transactional(readOnly = false)
	public void save(ShopSaleChannel shopSaleChannel) {
		if (shopSaleChannel.getIsNewRecord()){
			shopSaleChannel.preInsert();
			shopSaleChannel.setCode(System.currentTimeMillis()+"");
			dao.insert(shopSaleChannel);
		}else{
			shopSaleChannel.preUpdate();
			dao.update(shopSaleChannel);
		}
	}
	
	@Transactional(readOnly = false)
	public void delete(ShopSaleChannel shopSaleChannel) {
		super.delete(shopSaleChannel);
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void importChannel(MultipartFile file) {
		try {
			ImportExcel ei = new ImportExcel(file,0,0);
			List<ShopSaleChannel> list = ei.getDataList(ShopSaleChannel.class);
			for(ShopSaleChannel ssc :list){
				ssc.setIsValid(DictUtils.getDictValue(ssc.getIsValid(),"yes_no","0"));
				ssc.setType(DictUtils.getDictValue(ssc.getType(),"channel_type","0"));
				ssc.setArea(UserUtils.getAreaByName(ssc.getAreaName()).getId());
				ssc.setDept(UserUtils.getOfficeByName(ssc.getDeptName()).getId());
				save(ssc);
			}
		} catch (Exception e) {
			new ZAException(-1, "销售渠道导入出错！");
		}

	}
	@Transactional(readOnly = false)
	public void export(ShopSaleChannel shopSaleChannel,HttpServletResponse response) throws IOException {
		List<ShopSaleChannel> channelList=dao.findList(shopSaleChannel);
		for(ShopSaleChannel ssc :channelList){
			ssc.setIsValid(DictUtils.getDictLabel(ssc.getIsValid(),"yes_no","否"));
			ssc.setType(DictUtils.getDictLabel(ssc.getType(),"channel_type","CKU俱乐部"));
		};
		new ExportExcel("", ShopSaleChannel.class,2).setDataList(channelList).write(response, "销售渠道.xlsx").dispose();
	}
}