package com.cku.oa.order.vo;

import com.cku.oa.sys.entity.user.Member;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author yuanshuai
 * @date 2023/6/15 17:54
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
public class OrderSkuVo implements Serializable {
    private static final long serialVersionUID = -1377028452955332655L;

    @ApiModelProperty("订单号")
    private String orderCode;

    @ApiModelProperty("会员信息")
    private Member member;

    @ApiModelProperty("商品ID")
    private String skuId;

    @ApiModelProperty("商品名称")
    private String skuName;

    @ApiModelProperty("数量")
    private Integer num;

    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    @ApiModelProperty("总价")
    private BigDecimal totalPrice;

    @ApiModelProperty("业务信息列表")
    private List<OrderBusinessVo> businessList;

}
