package com.cku.oa.groomerRefereeDelegate.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomerRefereeDelegate.dao.GroomerRefereeDelegateLogDao;
import com.cku.oa.groomerRefereeDelegate.entity.GroomerRefereeDelegateLog;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.List;

/**
 * 美容裁判委派记录Service
 *
 * @author 袁帅
 * @version 2021-03-16
 */
@Service
@Transactional(readOnly = true)
public class GroomerRefereeDelegateLogService extends CrudService<GroomerRefereeDelegateLogDao, GroomerRefereeDelegateLog> {

	@Override
	public GroomerRefereeDelegateLog get(String id) {
		return super.get(id);
	}

	@Override
	public List<GroomerRefereeDelegateLog> findList(GroomerRefereeDelegateLog groomerRefereeDelegateLog) {
		return super.findList(groomerRefereeDelegateLog);
	}

	@Override
	public Page<GroomerRefereeDelegateLog> findPage(Page<GroomerRefereeDelegateLog> page, GroomerRefereeDelegateLog groomerRefereeDelegateLog) {
		return super.findPage(page, groomerRefereeDelegateLog);
	}

	@Override
	@Transactional(readOnly = false)
	public void save(GroomerRefereeDelegateLog groomerRefereeDelegateLog) {
		super.save(groomerRefereeDelegateLog);
	}

	@Override
	@Transactional(readOnly = false)
	public void delete(GroomerRefereeDelegateLog groomerRefereeDelegateLog) {
		super.delete(groomerRefereeDelegateLog);
	}

	/**
	 * 导入模板
	 *
	 * @author yuanshuai
	 * @date 2021/3/17 14:28
	 */
	public void importFileTemplate(HttpServletResponse response) throws IOException {
		List<GroomerRefereeDelegateLog> delegateLogList = Lists.newArrayList();
		GroomerRefereeDelegateLog delegateLog = new GroomerRefereeDelegateLog();
		delegateLog.setMainShowId("202110");
		delegateLog.setCount(6);
		delegateLog.setRegion("华北");
		delegateLog.setStartDate(new Date());
		delegateLog.setEndDate(new Date());
		delegateLog.setCity("石家庄");
		delegateLog.setProvince("河北");
		delegateLog.setReferees("张三,李四,王五,王六,王七,王八（用英文逗号分隔）");
		delegateLogList.add(delegateLog);
		ExportExcel exportExcel = new ExportExcel("美容委派记录导入模板", GroomerRefereeDelegateLog.class, 2);
		exportExcel.setDataList(delegateLogList, 0);
		exportExcel.write(response, "美容委派记录导入模板.xlsx").dispose();
	}

	/**
	 * 导入数据
	 *
	 * @author yuanshuai
	 * @date 2021/3/17 14:29
	 */
	@Transactional(readOnly = false)
	public void importGroomerReferee(MultipartFile file) throws IOException, InvalidFormatException, IllegalAccessException, InstantiationException {
		ImportExcel delegateLogIe = new ImportExcel(file, 1, 0);
		List<GroomerRefereeDelegateLog> importList = delegateLogIe.getDataList(GroomerRefereeDelegateLog.class);
		importList.stream()
				.filter(delegateLog -> !StringUtils.isBlank(delegateLog.getMainShowId()))
				.forEach(delegateLog -> {
					if (checkDuplicateByMainShowId(delegateLog.getMainShowId())) {
						throw new ZAException(ZAErrorCode.ZA_ERROR, delegateLog.getMainShowId() + "美容活动已经录入过，请删除后重试");
					}
					int refereeCount = delegateLog.getReferees().split(",").length;
					if (refereeCount != delegateLog.getCount()) {
						throw new ZAException(ZAErrorCode.ZA_ERROR, delegateLog.getMainShowId() + "美容活动人次与裁判数量不一致（裁判需用英文逗号分隔）");
					}
					delegateLog.setRegion(DictUtils.getDictValue(delegateLog.getRegion(), "show_region", "0"));
					save(delegateLog);
				});
	}

	public boolean checkDuplicateByMainShowId(String mainShowId) {
		if (dao.getCountByMainShowId(mainShowId) > 0) {
			return true;
		}
		return false;
	}
}