/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 出口证书申请Entity
 * 
 * @author lgl
 * @version 2016-08-19
 */
public class DogPedigreeCertifiedExport extends DataEntity<DogPedigreeCertifiedExport> {

	private static final long serialVersionUID = 1L;
	private String dogId; // 犬只信息表主键
	private String pedigreeCertified; // 血统证书号
	private String exportCountry; // 出口国家
	private String exportDestination; // 出口目的地
	private String exporter; // 出口人
	private String paymentMemberCode; // 付款会员号
	private String operator; // 操作人
	private String price; // 价格
	private String reviewState; // 审核状态
	private Date reviewTime; // 审核时间
	private String reviewRemarks; // 审核的意见
	private String runningNumber; // 流水号
	private String paymentState; // 付款的状态
	private Date paymentTime; // 付款时间
	private Date processTime; // 流程变更的时间
	private String processState; // 流程状态
	private Date beginCreateDate; // 开始 create_date
	private Date endCreateDate; // 结束 create_date
	private String dogOwner; // 犬主人
	private String nameEn; // 英文姓名
	private String identificationFlag; // 身份识别标记
	private String dogBreed; // 犬种
	private String printState; // dog表的打印状态
	private String colorFlag; // 颜色及标志
	private String colorFlagCode; // 颜色及标志
	private Date birthdate; // 出生日期
	private String breedCnName; // 犬种类中文名称
	private String breedEnName; // 犬种类英文名称
	private String paymentChargingItemId; // 收费项id
	private Date printTime;
	private Dog dog; // 打印时保存打印所需信息
	private DogNewborn dogNewborn; // 打印时保存打印所需信息

	private String reviewStateExclud; // 排除的审核状态
	private String reviewStateStr;

	private String hospitalCode;
	private Boolean dogDnaArchiveFlag;
	private String vodUrl;
	private String hospitalName;
	private String hospitalProvince;
	private String gender;
	private String oldVodurl;
	
	private String applyChannel;
	
	public String getApplyChannel() {
		return applyChannel;
	}

	public void setApplyChannel(String applyChannel) {
		this.applyChannel = applyChannel;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getHospitalName() {
		return hospitalName;
	}

	public void setHospitalName(String hospitalName) {
		this.hospitalName = hospitalName;
	}

	public String getHospitalProvince() {
		return hospitalProvince;
	}

	public void setHospitalProvince(String hospitalProvince) {
		this.hospitalProvince = hospitalProvince;
	}

	public String getVodUrl() {
		return vodUrl;
	}

	public void setVodUrl(String vodUrl) {
		this.vodUrl = vodUrl;
	}

	public Boolean getDogDnaArchiveFlag() {
		return dogDnaArchiveFlag;
	}

	public void setDogDnaArchiveFlag(Boolean dogDnaArchiveFlag) {
		this.dogDnaArchiveFlag = dogDnaArchiveFlag;
	}

	public String getHospitalCode() {
		return hospitalCode;
	}

	public void setHospitalCode(String hospitalCode) {
		this.hospitalCode = hospitalCode;
	}

	public Date getPrintTime() {
		return printTime;
	}

	public void setPrintTime(Date printTime) {
		this.printTime = printTime;
	}

	public String getReviewStateExclud() {
		return reviewStateExclud;
	}

	public void setReviewStateExclud(String reviewStateExclud) {
		this.reviewStateExclud = reviewStateExclud;
	}

	public DogPedigreeCertifiedExport() {
		super();
	}

	public DogPedigreeCertifiedExport(String id) {
		super(id);
	}

	public DogPedigreeCertifiedExport(String runningNumber, String paymentChargingItemId, String paymentMemberCode) {
		this.runningNumber = runningNumber;
		this.paymentChargingItemId = paymentChargingItemId;
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 0, max = 64, message = "犬只信息表主键长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	@Length(min = 0, max = 64, message = "血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public String getExportCountry() {
		return exportCountry;
	}

	public void setExportCountry(String exportCountry) {
		this.exportCountry = exportCountry;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	@Length(min = 0, max = 200, message = "出口目的地长度必须介于 0 和 200 之间")
	public String getExportDestination() {
		return exportDestination;
	}

	public void setExportDestination(String exportDestination) {
		this.exportDestination = exportDestination;
	}

	@Length(min = 0, max = 64, message = "出口人长度必须介于 0 和 64 之间")
	public String getExporter() {
		return exporter;
	}

	public void setExporter(String exporter) {
		this.exporter = exporter;
	}

	@Length(min = 0, max = 64, message = "付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 0, max = 64, message = "操作人长度必须介于 0 和 64 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min = 0, max = 20, message = "审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min = 0, max = 50, message = "审核的意见长度必须介于 0 和 50 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min = 0, max = 100, message = "流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 20, message = "付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	@Length(min = 0, max = 20, message = "流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getDogOwner() {
		return dogOwner;
	}

	public void setDogOwner(String dogOwner) {
		this.dogOwner = dogOwner;
	}

	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	public String getColorFlag() {
		return colorFlag;
	}

	public void setColorFlag(String colorFlag) {
		this.colorFlag = colorFlag;
	}

	public String getColorFlagCode() {
		return colorFlagCode;
	}

	public void setColorFlagCode(String colorFlagCode) {
		this.colorFlagCode = colorFlagCode;
	}

	public Date getBirthdate() {
		return birthdate;
	}

	public void setBirthdate(Date birthdate) {
		this.birthdate = birthdate;
	}

	public String getBreedCnName() {
		return breedCnName;
	}

	public void setBreedCnName(String breedCnName) {
		this.breedCnName = breedCnName;
	}

	public String getBreedEnName() {
		return breedEnName;
	}

	public void setBreedEnName(String breedEnName) {
		this.breedEnName = breedEnName;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public Dog getDog() {
		return dog;
	}

	public void setDog(Dog dog) {
		this.dog = dog;
	}

	public DogNewborn getDogNewborn() {
		return dogNewborn;
	}

	public void setDogNewborn(DogNewborn dogNewborn) {
		this.dogNewborn = dogNewborn;
	}

	private Dog dog1 = new Dog();
	private Dog dog2 = new Dog();
	private Dog dog3 = new Dog();
	private Dog dog4 = new Dog();
	private Dog dog5 = new Dog();
	private Dog dog6 = new Dog();
	private Dog dog7 = new Dog();
	private Dog dog8 = new Dog();
	private Dog dog9 = new Dog();
	private Dog dog10 = new Dog();
	private Dog dog11 = new Dog();
	private Dog dog12 = new Dog();
	private Dog dog13 = new Dog();
	private Dog dog14 = new Dog();
	private Dog dog15 = new Dog();
	private Dog dog16 = new Dog();
	private Dog dog17 = new Dog();
	private Dog dog18 = new Dog();
	private Dog dog19 = new Dog();
	private Dog dog20 = new Dog();
	private Dog dog21 = new Dog();
	private Dog dog22 = new Dog();
	private Dog dog23 = new Dog();
	private Dog dog24 = new Dog();
	private Dog dog25 = new Dog();
	private Dog dog26 = new Dog();
	private Dog dog27 = new Dog();
	private Dog dog28 = new Dog();
	private Dog dog29 = new Dog();
	private Dog dog30 = new Dog();

	public Dog getDog1() {
		return dog1;
	}

	public void setDog1(Dog dog1) {
		this.dog1 = dog1;
	}

	public Dog getDog2() {
		return dog2;
	}

	public void setDog2(Dog dog2) {
		this.dog2 = dog2;
	}

	public Dog getDog3() {
		return dog3;
	}

	public void setDog3(Dog dog3) {
		this.dog3 = dog3;
	}

	public Dog getDog4() {
		return dog4;
	}

	public void setDog4(Dog dog4) {
		this.dog4 = dog4;
	}

	public Dog getDog5() {
		return dog5;
	}

	public void setDog5(Dog dog5) {
		this.dog5 = dog5;
	}

	public Dog getDog6() {
		return dog6;
	}

	public void setDog6(Dog dog6) {
		this.dog6 = dog6;
	}

	public Dog getDog7() {
		return dog7;
	}

	public void setDog7(Dog dog7) {
		this.dog7 = dog7;
	}

	public Dog getDog8() {
		return dog8;
	}

	public void setDog8(Dog dog8) {
		this.dog8 = dog8;
	}

	public Dog getDog9() {
		return dog9;
	}

	public void setDog9(Dog dog9) {
		this.dog9 = dog9;
	}

	public Dog getDog10() {
		return dog10;
	}

	public void setDog10(Dog dog10) {
		this.dog10 = dog10;
	}

	public Dog getDog11() {
		return dog11;
	}

	public void setDog11(Dog dog11) {
		this.dog11 = dog11;
	}

	public Dog getDog12() {
		return dog12;
	}

	public void setDog12(Dog dog12) {
		this.dog12 = dog12;
	}

	public Dog getDog13() {
		return dog13;
	}

	public void setDog13(Dog dog13) {
		this.dog13 = dog13;
	}

	public Dog getDog14() {
		return dog14;
	}

	public void setDog14(Dog dog14) {
		this.dog14 = dog14;
	}

	public Dog getDog15() {
		return dog15;
	}

	public void setDog15(Dog dog15) {
		this.dog15 = dog15;
	}

	public Dog getDog16() {
		return dog16;
	}

	public void setDog16(Dog dog16) {
		this.dog16 = dog16;
	}

	public Dog getDog17() {
		return dog17;
	}

	public void setDog17(Dog dog17) {
		this.dog17 = dog17;
	}

	public Dog getDog18() {
		return dog18;
	}

	public void setDog18(Dog dog18) {
		this.dog18 = dog18;
	}

	public Dog getDog19() {
		return dog19;
	}

	public void setDog19(Dog dog19) {
		this.dog19 = dog19;
	}

	public Dog getDog20() {
		return dog20;
	}

	public void setDog20(Dog dog20) {
		this.dog20 = dog20;
	}

	public Dog getDog21() {
		return dog21;
	}

	public void setDog21(Dog dog21) {
		this.dog21 = dog21;
	}

	public Dog getDog22() {
		return dog22;
	}

	public void setDog22(Dog dog22) {
		this.dog22 = dog22;
	}

	public Dog getDog23() {
		return dog23;
	}

	public void setDog23(Dog dog23) {
		this.dog23 = dog23;
	}

	public Dog getDog24() {
		return dog24;
	}

	public void setDog24(Dog dog24) {
		this.dog24 = dog24;
	}

	public Dog getDog25() {
		return dog25;
	}

	public void setDog25(Dog dog25) {
		this.dog25 = dog25;
	}

	public Dog getDog26() {
		return dog26;
	}

	public void setDog26(Dog dog26) {
		this.dog26 = dog26;
	}

	public Dog getDog27() {
		return dog27;
	}

	public void setDog27(Dog dog27) {
		this.dog27 = dog27;
	}

	public Dog getDog28() {
		return dog28;
	}

	public void setDog28(Dog dog28) {
		this.dog28 = dog28;
	}

	public Dog getDog29() {
		return dog29;
	}

	public void setDog29(Dog dog29) {
		this.dog29 = dog29;
	}

	public Dog getDog30() {
		return dog30;
	}

	public void setDog30(Dog dog30) {
		this.dog30 = dog30;
	}

	public String getReviewStateStr() {
		return reviewStateStr;
	}

	public void setReviewStateStr(String reviewStateStr) {
		this.reviewStateStr = reviewStateStr;
	}

	public String getOldVodurl() {
		return oldVodurl;
	}

	public void setOldVodurl(String oldVodurl) {
		this.oldVodurl = oldVodurl;
	}

	
}