/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 语言Entity
 * @author yuanshuai
 * @version 2020-10-12
 */
public class Language extends DataEntity<Language> {
	
	private static final long serialVersionUID = 1L;
	private String languageNo;		// 编号
	private String code;		// 代码
	private String name;		// 名称
	
	public Language() {
		super();
	}

	public Language(String id){
		super(id);
	}

	@Length(min=1, max=11, message="编号长度必须介于 1 和 11 之间")
	public String getLanguageNo() {
		return languageNo;
	}

	public void setLanguageNo(String languageNo) {
		this.languageNo = languageNo;
	}
	
	@Length(min=1, max=5, message="代码长度必须介于 1 和 5 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@Length(min=1, max=32, message="名称长度必须介于 1 和 32 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
}