//package com.cku.oa.components.rule.validation.member;
//
//import java.util.ArrayList;
//import java.util.Calendar;
//import java.util.Date;
//import java.util.List;
//
//import com.cku.oa.components.rule.Validation;
//import com.cku.oa.components.rule.validation.dog.DogCondition;
//import com.cku.oa.components.rule.validation.kennel.KennelCondition;
//import com.cku.oa.dog.entity.Dog;
//import com.cku.oa.kennel.entity.Kennel;
//import com.cku.oa.show.entity.ChampionLogin;
//import com.cku.oa.sys.entity.user.Member;
//import com.cku.oa.sys.entity.user.MemberType;
//import com.ql.util.express.DefaultContext;
//import com.ql.util.express.ExpressRunner;
//import com.ql.util.express.IExpressContext;
//import org.springframework.stereotype.Component;
//
//@Component
//public class MemberValidation extends Validation{
//
//
//	private static final String MEMBER_BASIC = "基础会员";
//	private static final String MEMBER_PROFESSIONAL = "专业会员";
//	private static final String ACTIVE_MEMBER_OR_GROOMER = "有效会员或者美容师";
//	private static final String ACTIVE_MEMBER = "有效会员";
//	private static final String ACTIVE_GROOMER = "有效美容师会员";
//	private Member member;
//	private String expression;
//	private String userName;
//
////	public MemberValidation(String userName,Member member,String expression) throws Exception{
////		this.userName = userName;
////		this.member = member;
////		this.expression = expression;
////		initial();
////	}
//
//	public void initial() throws Exception{
//		runner.addFunctionOfClassMethod("isBasicMember", MemberCondition.class.getName(), "isBasicMember",new String[] {Member.class.getName()}, this.userName + "不是基础会员");
//		runner.addMacro(MEMBER_BASIC, "isBasicMember(member)");
//
//		runner.addFunctionOfClassMethod("isProfessionalMember",MemberCondition.class.getName(),"isProfessionalMember",new String[] {Member.class.getName()}, this.userName + "不是专业");
//		runner.addMacro(MEMBER_PROFESSIONAL,"isProfessionalMember(member)");
//
//		runner.addFunctionOfClassMethod("isActiveMemberOrGroomer",MemberCondition.class.getName(),"isActiveMemberOrGroomer",new String[] {Member.class.getName()}, this.userName + "不是有效会员或有效美容师会员");
//		runner.addMacro(ACTIVE_MEMBER_OR_GROOMER,"isActiveMemberOrGroomer(member)");
//
//		runner.addFunctionOfClassMethod("isActiveMember",MemberCondition.class.getName(),"isActiveMember",new String[] {Member.class.getName()}, this.userName + "不是有效会员");
//		runner.addMacro(ACTIVE_MEMBER,"isActiveMember(member)");
//
//		runner.addFunctionOfClassMethod("isActiveGroomer",MemberCondition.class.getName(),"isActiveGroomer",new String[] {Member.class.getName()}, this.userName + "不是有效美容师");
//		runner.addMacro(ACTIVE_GROOMER,"isActiveGroomer(member)");
//	}
//
//	/**
//	 * 执行逻辑判断
//	 * @throws Exception
//	 */
//	public List<String> validate() throws Exception{
//		List<String> errorInfo = new ArrayList<String>();
//		IExpressContext<String,Object> expressContext = new DefaultContext<String,Object>();
//		expressContext.put("member",member);
//        Boolean result = (Boolean)runner.execute(expression, expressContext, errorInfo, true, true);
//        return errorInfo;
//	}
//
//	public static void main(String args[]) throws Exception{
////		Member member = new Member();
////		member.setMemberType("basic");
////		MemberValidation rule = new MemberValidation("张三",member,MemberValidation.ACTIVE_GROOMER);
////
////		List<String> errors = rule.validate();
////
////		for(String s:errors){
////			System.out.println(s);
////		}
//	}
//
//
//
//
//
//	public static ExpressRunner runner;
//
//	static {
//		runner = new ExpressRunner();
//	}
//
//	private static boolean isInitialRunner = false;
//
//	@Override
//	protected void initRunner() {
//		if (isInitialRunner == true) {
//			return;
//		}
//		synchronized (runner) {
//			if (isInitialRunner == true) {
//				return;
//			}
//			try {
//				MemberCondition memberCondition = (MemberCondition)applicationContext.getBean("memberCondition");
//				runner.setShortCircuit(true);
//				runner.addOperatorWithAlias("而且", "and", null);
//				runner.addMacro("犬只状态正常", "0");
//				runner.addMacro("犬只状态出口", "5");
//				runner.addOperatorWithAlias("属于", "in", "犬只状态$1不在允许的范围");
//				runner.addOperatorWithAlias("如果", "if", null);
//				runner.addOperatorWithAlias("否则", "else", null);
//				runner.addMacro("青年登录", "7");
//				runner.addOperatorWithAlias("等于","==","$1 == $2 不符合");
//				runner.addOperatorWithAlias("大于",">","$1不大于要求的$2");
//				runner.addOperatorWithAlias("小于","<","$1不小于要求的$2");
//				runner.addFunctionOfServiceMethod("isActiveMemberOrGroomer", memberCondition, "isActiveMemberOrGroomer", new Class[]{Member.class}, "不是有效的会员或者有效的美容师会员");
//				runner.addMacro(ACTIVE_MEMBER_OR_GROOMER, "isActiveMemberOrGroomer(member)");
//				runner.addMacro("铜制登录", "2");
//				runner.addMacro("银制登录", "3");
//				runner.addMacro("金制登录", "4");
//				runner.addMacro("超级登录", "5");
//				runner.addMacro("世界冠军登录", "6");
//				runner.addOperatorWithAlias("或","or",null);
//			} catch (Exception e) {
//				throw new RuntimeException("初始化失败表达式", e);
//			}
//		}
//		isInitialRunner = true;
//	}
//
//}
