//修改密码-1，发送验证码
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //旧密码
        me.oldPassword = ko.observable("");
        //新密码
        me.newPassword = ko.observable("");
        //重复新密码
        me.douPassword = ko.observable("");


        //旧密码校验
        me.vaildOldPasswordFlag = ko.observable(false);
        me.vaildOldPassword = function(data){
            if(util.isVal(me.oldPassword())==""){
                $("#vaildOldPasswordDiv").html("<em></em><strong>旧密码不能为空</strong>");
                me.vaildOldPasswordFlag(false);
            }else{
                $("#vaildOldPasswordDiv").html("");
                me.vaildOldPasswordFlag(true);
            }
        }
        //新密码校验
        me.vaildNewPasswordFlag = ko.observable(false);
        me.vaildNewPassword = function(data){
        	var psw = me.newPassword();
        	var reg =/(^\s+)|(\s+$)/g; //校验是否有空格
            if(reg.test(psw)||util.isVal(psw)=="" || util.isVal(psw).length<6 || util.isVal(psw).search(/^(([a-zA-Z]+[0-9]+)|([0-9]+[a-zA-Z]+))[a-zA-Z0-9]*$/i)==-1 || util.isVal(psw).length>12){
                $("#vaildNewPasswordDiv").html("<em></em><strong>密码由6-12位数字和字母同时组成</strong>");
                me.vaildNewPasswordFlag(false);
            }else{
                $("#vaildNewPasswordDiv").html("");
                me.vaildNewPasswordFlag(true);
            }
        }
        //再次密码校验
        me.vaildDouPasswordFlag = ko.observable(false);
        me.vaildDouPassword = function(data){
            if(me.newPassword()!=me.douPassword()){
                $("#vaildDouPasswordDiv").html("<em></em><strong>两次输入的密码不一致</strong>");
                me.vaildDouPasswordFlag(false);
            }else{
                $("#vaildDouPasswordDiv").html("");
                me.vaildDouPasswordFlag(true);
            }
        }

        /**
         * 重新修改密码
         */
        me.updatePasswordFun = function(){
            if(me.vaildOldPasswordFlag() && me.vaildNewPasswordFlag() && me.vaildDouPasswordFlag()){
                var sendData = {};
                sendData["oldPassword"] = me.oldPassword();
                sendData["newPassword"] = me.newPassword();

                util.sendAjax({
                    url:'userCenter/password',
                    data:JSON.stringify(sendData),
                    async:true,
                    loadFlag:true,
                    type:'PUT',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            layer.msg("密码重置成功！");
                            location.href="login.html";
                        }else{
                            layer.msg("修改密码失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                        }
                    }
                });
            }
        }
        context.app.loading(false);
        context.app.isShop(false);
    }
});