<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作学校管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<shiro:hasPermission name="trainschool:groomer:edit"><li ><a  href="${ctx}/trainschool/trainingInstitution/groomerForm"><button type="button" class="btn btn-primary">美容师学校录入</button></a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="trainingInstitution" action="${ctx}/trainschool/trainingInstitution/groomerSchoolList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>学校中文：</label>
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>合作编号：</label>
				<form:input path="schoolMemberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>开放状态：</label>
				<form:select path="user.loginFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="开放"/>
					<form:option value="0" label="关闭"/>
				</form:select>
			</li>
			<li><label>学校缴费状态：</label>
				<form:select path="schoolMemberPayFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="已缴费"/>
					<form:option value="0" label="未缴费"/>
				</form:select>
			</li>
			<li><label>负责人缴费状态：</label>
				<form:select path="responsiblerMemberPayFlag" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="已缴费"/>
					<form:option value="0" label="未缴费"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>学校中文</th>
				<th>学校类别</th>
				<th>截止日期</th>
				<th>合作编号</th>
				<th>开放状态</th>
				<th>学校缴费状态</th>
				<th>余额</th>
				<th>负责人缴费状态</th>
				<th>邮寄管理</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="trainingInstitution">
			<tr>
				<td>
					${fns:escapeHtml(trainingInstitution.schoolNameCn)}
				</td>
				<td>
					${fns:getDictLabel(trainingInstitution.schoolType, 'school_type', '')}
				</td>
				<td>
					<fmt:formatDate value="${trainingInstitution.member.memberEndDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(trainingInstitution.schoolMemberCode)}
				</td>
				<td>
					<c:if test="${not empty trainingInstitution.schoolUserId}">
						<c:if test="${trainingInstitution.user.loginFlag=='1'}"><font color="green">开放</font></c:if>
						<c:if test="${trainingInstitution.user.loginFlag!='1'}"><font color="red">关闭</font></c:if>
					</c:if>
				</td>
				<td>
					<c:if test="${trainingInstitution.schoolMemberPayFlag=='1'}"><font color="green">已缴费</font></c:if>
					<c:if test="${trainingInstitution.schoolMemberPayFlag=='0'}"><font color="red">未缴费</font></c:if>
				</td>
				<td>
					${fns:escapeHtml(trainingInstitution.member.accountBalance)}
				</td>
				<td>
					<c:if test="${not empty trainingInstitution.memberCode}">
						<c:if test="${trainingInstitution.responsiblerMemberPayFlag=='1'}"><font color="green">已缴费</font></c:if>
						<c:if test="${trainingInstitution.responsiblerMemberPayFlag=='0'}"><font color="red">未缴费</font></c:if>
					</c:if>
				</td>
				<td>
					<a href="${ctx}/trainschool/groomerSchoolMail/form?schoolId=${fns:escapeHtml(trainingInstitution.id)}">录入</a>
					<a href="${ctx}/trainschool/groomerSchoolMail/list?schoolId=${fns:escapeHtml(trainingInstitution.id)}">管理</a>
				</td>
				<td>
				<shiro:hasPermission name="trainschool:groomer:edit">
    				<a href="${ctx}/trainschool/trainingInstitution/groomerForm?id=${fns:escapeHtml(trainingInstitution.id)}">编辑</a>
    				<a style="color:red;" href="${ctx}/trainschool/trainingInstitution/stopSchoolFlag?id=${trainingInstitution.id}" onclick="return confirmx('确认要停止该美容学校的合作吗？', this.href)">停止合作</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="trainschool:groomer:delete">
					<a href="${ctx}/trainschool/trainingInstitution/groomerSchoolDelete?id=${fns:escapeHtml(trainingInstitution.id)}" onclick="return confirmx('确认要删除该美容学校吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>