<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#btnImport").click(function(){
                $.jBox($("#importBox").html(), {title:"冠军登录导入", buttons:{"关闭":true},
                    bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
            });

            //显示导入错误提示
            var importError = "${importError}";
            var reg = new RegExp("##", "g");
            if (importError != null && importError != '' && typeof importError != 'undefined') {
                alert(importError.replace(reg, "\n"));
            }
        });
        function page(n,s){
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
    <div id="importBox" class="hide">
        <form id="importForm" action="${ctx}/championlogin/championLogin/import" method="post" enctype="multipart/form-data"
              class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
            <input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
            <input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
            <a href="${ctx}/championlogin/championLogin/import/template">下载模板</a>
        </form>
    </div>
    <ul class="nav nav-tabs">
        <li class="active"><a href="${ctx}/championlogin/championLogin/">冠军登录信息列表</a></li>
    </ul>
    <form:form id="searchForm" modelAttribute="championLogin" action="${ctx}/championlogin/championLogin/" method="post" class="breadcrumb form-search">
        <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
        <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
        <ul class="ul-form">
        	<li><label>犬主/会员号：</label>
                <form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
            </li>
            <li><label>登录类型：</label>
                <form:select path="loginType" class="input-medium">
                    <form:option value="" label="全部 "/>
                    <form:options items="${fns:getDictList('champion_login')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>登录序号：</label>
                <form:input path="loginCode" htmlEscape="false" maxlength="100" class="input-medium"/>
            </li>
            <li><label>血统证书号：</label>
                <form:input path="pedigreeCertified" htmlEscape="false" maxlength="100" class="input-medium"/>
            </li>
            <li><label>支付状态：</label>
                <form:select path="paymentState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>审核状态：</label>
                <form:select path="reviewState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('champion_login_review')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>打印状态：</label>
                <form:select path="printState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('print_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>申请时间：</label>
                <input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                       value="<fmt:formatDate value="${championLogin.beginCreateDate}" pattern="yyyy-MM-dd"/>"
                       onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
                <input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                       value="<fmt:formatDate value="${championLogin.endCreateDate}" pattern="yyyy-MM-dd"/>"
                       onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </li>
            <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
            <shiro:hasPermission name="championlogin:championLogin:import">
                <li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="导入登录信息"/></li>
            </shiro:hasPermission>
            <li class="clearfix"></li>
        </ul>
    </form:form>
    <sys:message content="${message}"/>
    <table id="contentTable" class="table table-striped table-bordered table-condensed">
        <thead>
            <tr>
                <th>缴费流水号</th>
                <th>登录类型</th>
                <th>登录序号</th>
                <th>犬主人</th>
                <th>会员号</th>
                <th>血统证书号</th>
                <th>身份识别标志</th>
                <th>犬名</th>
                <th>DNA存档</th>
                <th>申请时间</th>
                <th>支付状态</th>
                <th>审核状态</th>
                <th>打印状态</th>
                <shiro:hasPermission name="championlogin:championLogin:edit"><th>操作</th></shiro:hasPermission>
            </tr>
        </thead>
        <tbody>
        <c:forEach items="${page.list}" var="championLogin">
            <tr>
                <td>
                    ${fns:escapeHtml(championLogin.runningNumber) }
                </td>
                <td>
                    ${fns:getDictLabel(championLogin.loginType, 'main_login_type', fns:getDictLabel(championLogin.loginType, 'champion_login_type', ''))}
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.loginCode) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.dogOwner) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.memberCode) }
                </td>
                <td>
                    <a target="_blank" href="${dogInfoURL}${championLogin.pedigreeCertified}">
                        ${fns:escapeHtml(championLogin.pedigreeCertified) }
                    </a>
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.identificationFlag) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.nameEn) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.isHaveDogDna) }
                </td>
                <td>
                    <fmt:formatDate value="${championLogin.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
                <td>
                    <c:if test="${championLogin.paymentState=='1'}"><font color="red">
                        <shiro:hasPermission name="finance:deductCost:deductCost"><a onclick="util.pay('${championLogin.id}','${championLogin.shortName}',1,'','${championLogin.dog.memberCode}')"></shiro:hasPermission>${fns:getDictLabel(championLogin.paymentState, 'user_payment_state', '')}
                        <shiro:hasPermission name="finance:deductCost:deductCost"></a></shiro:hasPermission>
                        </font>
                    </c:if>
                    <c:if test="${championLogin.paymentState=='2'}"><font color="green">
                        ${fns:getDictLabel(championLogin.paymentState, 'user_payment_state', '')}
                        </font>
                    </c:if>
                </td>
                <td><c:if test="${championLogin.reviewState=='0'}"><font color="red"></c:if>
                    ${fns:getDictLabel(championLogin.reviewState, 'champion_login_review', '')}
                    <c:if test="${championLogin.reviewState=='0'}"></font></c:if>
                </td>
                <td>
                	<c:if test="${championLogin.loginType!='6' && championLogin.reviewState=='1' && championLogin.paymentState=='2'}">
                    	<shiro:hasPermission name="championlogin:championLogin:print">
                    <c:if test="${championLogin.printState!='1'}"><a href="${ctx}/championlogin/championLogin/print?id=${championLogin.id}" onclick="return confirmx('确认要进行该冠军登录打印吗？', this.href)"></c:if>
                        ${fns:getDictLabel(championLogin.printState, 'print_state', '')}
                    <c:if test="${championLogin.printState!='1'}"></a></c:if>
                    </shiro:hasPermission>
                    <shiro:hasPermission name="championlogin:championLogin:resetPrint">
                        <c:if test="${championLogin.printState=='1'}">
                            <a href="${ctx}/championlogin/championLogin/resetPrint?id=${championLogin.id}" onclick="return confirmx('确认要重置该冠军登录打印吗？', this.href)">重置</a>
                        </c:if>
                    </shiro:hasPermission>
                    </c:if>
                </td>
                <td>
                <shiro:hasPermission name="championlogin:championLogin:view">
                    <a href="${ctx}/championlogin/championLogin/view?id=${championLogin.id}">查看</a>
                </shiro:hasPermission>
                <c:if test="${!championLogin.businessRefundState}">
                	<shiro:hasPermission name="championlogin:championLogin:edit">
                   		<a href="${ctx}/championlogin/championLogin/form?id=${championLogin.id}">编辑</a>
                 	</shiro:hasPermission>
                	<shiro:hasPermission name="championlogin:championLogin:delete">
                 	   <a href="${ctx}/championlogin/championLogin/delete?id=${championLogin.id}" onclick="return confirmx('确认要删除该冠军登录信息吗？', this.href)">删除</a>
                	</shiro:hasPermission>
                </c:if>
                </td>
            </tr>
        </c:forEach>
        </tbody>
    </table>
    <div class="pagination">${page}</div>
</body>
</html>