<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>登记卡管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		/* function deleteAll(id){ 
			var remarks = prompt("删除原因:","");
			if(remarks){
				window.location.href="${ctx}/birthcertificate/dogBirthCertificate/deleteAll?remarks="+remarks+"&id="+id;
			}else if(remarks == ""){
				alert("删除原因不能为空！！");
			} else{
				return false;
			}
		} */
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li ><a href="${ctx}/birthcertificate/dogBirthCertificate/list">登记卡管理</a></li>
		<shiro:hasPermission name="birthcertificate:dogBirthCertificate:edit">
		</shiro:hasPermission>
	    <li class="active"><a href="${ctx}/birthcertificate/dogBirthCertificate/transferList">登记卡变更</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogBirthCertificateTransfer" action="${ctx}/birthcertificate/dogBirthCertificate/transferList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>登记卡编号：</label>
				<form:input path="birthCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			
			<li><label>会员号/姓名：</label>
				<form:input path="memberKey" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			
			<li><label>申请时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificateTransfer.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> 
					-
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogBirthCertificateTransfer.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			
			
		
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>登记卡编号</th>
				<th>英文犬名</th>
				<th>性别</th>
				<th>犬种</th>
				<th>出生日期</th>
				<th>芯片号码</th>
				<th>宠爱护照号</th>
				<th>繁殖人</th>
				<th>新犬主</th>
				<th>申请日期</th>
				<th>业务状态</th>
				<th>备注</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="obj">
			<tr>
				<td>
					${fns:escapeHtml(obj.birthCode)}
				</td>
				<td>
					${fns:escapeHtml(obj.dogEnName)}
				</td>
				<td>
					${fns:getDictLabel(obj.dogGender, 'dog_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(obj.dogBreed)}
				</td>
				<td>
					<fmt:formatDate value="${obj.dogBirth}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(obj.idNo)}
				</td>
				<td>
					${fns:escapeHtml(obj.cabPassport)}
				</td>
				
				<td>
					${fns:escapeHtml(obj.transferorMemberCode)} - ${fns:escapeHtml(obj.transferorMemberName)} 
				</td> 
				<td>
					${fns:escapeHtml(obj.receiverMemberCode)} - ${fns:escapeHtml(obj.receiverMemberName)} 
				</td> 
				<td>
					<fmt:formatDate value="${obj.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td> 
					<c:if test="${obj.businessStatus=='0'}">通过</c:if>
					<c:if test="${obj.businessStatus=='1'}">未通过</c:if>
					<c:if test="${obj.businessStatus=='2'}">待审核</c:if>
				</td> 
				<td>
					${fns:escapeHtml(obj.remark)}  
				</td> 
				<td>				
					<a href="${ctx}/birthcertificate/dogBirthCertificate/transferForm?id=${obj.id}">查看</a>
					<a href="${ctx}/birthcertificate/dogBirthCertificate/transferEditForm?id=${obj.id}">编辑</a>
				</td> 
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>