<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>规则年龄组别对照管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/contest/contestJudgeTypeClass/">规则年龄组别对照列表</a></li>
		<shiro:hasPermission name="contest:contestJudgeTypeClass:edit"><li><a href="${ctx}/contest/contestJudgeTypeClass/form">规则年龄组别对照添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="contestJudgeTypeClass" action="${ctx}/contest/contestJudgeTypeClass/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>规则代码：</label>
				<form:input path="judgeType" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>年龄组别编号：</label>
				<form:input path="classNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>年龄组别代码：</label>
				<form:input path="code" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>年龄组别名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>规则代码</th>
				<th>年龄组别编号</th>
				<th>年龄组别代码</th>
				<th>年龄组别名称</th>
				<th>排序</th>
				<shiro:hasPermission name="contest:contestJudgeTypeClass:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="contestJudgeTypeClass">
			<tr>
				<td><a href="${ctx}/contest/contestJudgeTypeClass/form?id=${contestJudgeTypeClass.id}">
					${contestJudgeTypeClass.judgeType}
				</a></td>
				<td>
					${contestJudgeTypeClass.classNo}
				</td>
				<td>
					${contestJudgeTypeClass.code}
				</td>
				<td>
					${contestJudgeTypeClass.name}
				</td>
				<td>
					${contestJudgeTypeClass.sortNo}
				</td>
				<shiro:hasPermission name="contest:contestJudgeTypeClass:edit"><td>
    				<a href="${ctx}/contest/contestJudgeTypeClass/form?id=${contestJudgeTypeClass.id}">修改</a>
					<a href="${ctx}/contest/contestJudgeTypeClass/delete?id=${contestJudgeTypeClass.id}" onclick="return confirmx('确认要删除该规则年龄组别对照吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>