<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>种公信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/studdog/studDog/">种公信息列表</a></li>
    <shiro:hasPermission name="studdog:studDog:edit">
        <li><a href="${ctx}/studdog/studDog/form">种公信息添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="studDog" action="${ctx}/studdog/studDog/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>状态：0未上架；1已上架：</label>
            <form:input path="state" htmlEscape="false" maxlength="2" class="input-medium"/>
        </li>
        <li><label>犬只血统证书号：</label>
            <form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>犬种号：</label>
            <form:input path="dogBreed" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>犬主会员号：</label>
            <form:input path="memberCode" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>是否可以上门配种标记位。0不可以；1可以：</label>
            <form:input path="doorToDoorFlag" htmlEscape="false" maxlength="1" class="input-medium"/>
        </li>
        <li><label>上架时间：</label>
            <input name="addTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${studDog.addTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>状态：0未上架；1已上架</th>
        <th>犬只血统证书号</th>
        <th>犬种号</th>
        <th>犬主会员号</th>
        <th>配种价格</th>
        <th>是否可以上门配种标记位。0不可以；1可以</th>
        <th>上架时间</th>
        <th>修改时间</th>
        <th>备注信息</th>
        <shiro:hasPermission name="studdog:studDog:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="studDog">
        <tr>
            <td><a href="${ctx}/studdog/studDog/form?id=${studDog.id}">
                    ${studDog.state}
            </a></td>
            <td>
                    ${studDog.pedigreeCertified}
            </td>
            <td>
                    ${studDog.dogBreed}
            </td>
            <td>
                    ${studDog.memberCode}
            </td>
            <td>
                    ${studDog.price}
            </td>
            <td>
                    ${studDog.doorToDoorFlag}
            </td>
            <td>
                <fmt:formatDate value="${studDog.addTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${studDog.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${studDog.remarks}
            </td>
            <shiro:hasPermission name="studdog:studDog:edit">
                <td>
                    <a href="${ctx}/studdog/studDog/form?id=${studDog.id}">修改</a>
                    <a href="${ctx}/studdog/studDog/delete?id=${studDog.id}"
                       onclick="return confirmx('确认要删除该种公信息吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>