<%@ tag language="java" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<%@ attribute name="name" type="java.lang.String" required="true" description="比赛犬种名称（ID）"%>
<%@ attribute name="value" type="java.lang.String" required="false" description="比赛犬种值（VALUE）"%>
<%@ attribute name="otherName" type="java.lang.String" required="true" description="其他犬种名称（ID）"%>
<%@ attribute name="otherValue" type="java.lang.String" required="false" description="其他犬种值（VALUE）"%>
<%@ attribute name="cssClass" type="java.lang.String" required="false" description="样式表"%>
<%@ attribute name="btnText" type="java.lang.String" required="false" description="按钮显示文字"%>
<%@ attribute name="memberElementId" type="java.lang.String" required="true" description="会员号元素ID"%>
<%@ attribute name="levelElementId" type="java.lang.String" required="true" description="级别元素ID"%>
<%@ attribute name="isSchool" type="java.lang.Boolean" required="false" description="是否是学校"%>
<%@ attribute name="validate" type="java.lang.String" required="false" description="是否开启验证规则"%>
<style type="text/css">
	.layui-layer-btn{
		border-top: 1px solid #ddd!important;
		text-align: right;
	    padding: 0 10px 12px;
	    pointer-events: auto;
	}
</style>
<script type="text/javascript">
	$(document).ready(function() {
		$('input[type=radio][name=${levelElementId}]').change(function() {
			$("#checkedBreedAndOther").val("");
			$("input[name=${name}]").val("");
			$("input[name=${otherName}]").val("");
		});
	});

	function showGroomerBreeds(){
		var checkedBreeds = encodeURIComponent($("#${name}Id").val());
		var otherBreeds = encodeURIComponent($("#${otherName}Id").val());
		var memberCode = $("#${memberElementId}").val();
		var showLevels = $("input[name=${levelElementId}]:checked").val();
		if(memberCode == undefined || memberCode == null || memberCode == "" 
				|| showLevels == undefined || showLevels == null || showLevels == ""){
			layer.msg("请选择会员和参赛级别后重试！");
			return false;
		}
		var containerLayer = parent.layer.open({
			type: 2,
			title: ['犬只品种选择', 'font-size:18px;text-align: center;'],
			shadeClose: false,
			shade: [0.3,'#696969'],
			maxmin: false,//开启最大化最小化按钮
			area: ['815px', '500px'],
			content: '${isSchool?ctxSchools:ctx}/groomer/groomerShowBreeds/showBreeds?memberCode='+memberCode+'&showLevels='+showLevels+'&checkedBreeds='+checkedBreeds+'&otherBreeds='+otherBreeds+'&validate=${empty validate?true:validate}',
			btn: ['确定', '取消'],
			yes: function(index, layero){
				var resultBreeds = $(layero).find('iframe')[0].contentWindow.getCheckedBreeds();
				if(resultBreeds){
					$("#"+"${name}Id").val(resultBreeds.checkedBreeds);
					$("#"+"${otherName}Id").val(resultBreeds.otherBreeds);
					$("#checkedBreedAndOther").val(resultBreeds.checkedBreeds + ( resultBreeds.otherBreeds == "" ? "":"#") + resultBreeds.otherBreeds);
					parent.layer.close(containerLayer);
				}
			}
		});
		return false;
	}
</script>
<div>
	<input id="checkedBreedAndOther" name="checkedBreedAndOther" placeholder="请点击右侧按钮选择" type="text" class="${cssClass}" value="${value}${empty otherValue?'':'#'}${otherValue}" readonly="readonly"/>
	<input id="${name}Id" name="${name}" type="hidden" value="${value}"/>
	<input id="${otherName}Id" name="${otherName}" type="hidden" value="${otherValue}"/>
	<input class="btn btn-primary" type="button" value="${empty btnText ? '请选择':btnText}" onclick="showGroomerBreeds();">
</div>
