/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v2.show.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.restful.v2.show.service.RestShowApplyServiceV2;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 赛事报名表Controller
 *
 * @author lgl
 * @version 2016-07-15
 */
@Controller
@RequestMapping(value = "/api/v2/show")
public class RestShowApplyControllerV2 extends BaseRestController {

    @Autowired
    private RestShowApplyServiceV2 restShowApplyService;

    @RequestMapping(value = "/agegroup", method = RequestMethod.GET)
    @ResponseBody
    public void getAgeGroup(HttpServletRequest request,
                            HttpServletResponse response) throws IOException {
        RESTResponse result = restShowApplyService.getAgeGroup(request);
        ServletUtils.writeResponse(response, result);
    }
}