package com.cku.restful.v1.sys.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.restful.v1.sys.service.RestMemberService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.modules.sys.security.SystemAuthorizingRealm.Principal;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

@Controller
@RequestMapping(value = "/api/v1/member")
public class RestMemberController extends BaseRestController {
	@Autowired
	private MemberService memberService;
	@Autowired
	private RestMemberService restMemberService;

	@RequestMapping(value = "", method = RequestMethod.GET)
	@ResponseBody
	public void getMember(@RequestParam String memberCode, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		Member member = memberService.getByMemberCode(memberCode);
		String apply = request.getParameter("apply");
		apply = apply == null ? "" : apply;
		if (member == null) {
			RESTResponse result = new RESTResponse(1, "没有找到任何会员信息");
			ServletUtils.writeResponse(response, result);
		} else {
			Subject subject = SecurityUtils.getSubject();
			Principal principal = (Principal) subject.getPrincipal();

			if (null != principal && !"yes".equals(apply)) {
				if (principal.getLoginType().equals("MemberCenter") && !StringUtils.isBlank(member.getMemberSite())) {
					RESTResponse result = new RESTResponse(1, "没有找到任何会员信息");
					ServletUtils.writeResponse(response, result);
					return;
				} else if (principal.getLoginType().equals("DcMemberCenter")
						&& StringUtils.isBlank(member.getMemberSite())) {
					RESTResponse result = new RESTResponse(1, "没有找到任何会员信息");
					ServletUtils.writeResponse(response, result);
					return;
				}
			}
			JSONObject object = new JSONObject();
			object.put("memberCode", memberCode);
			object.put("name", member.getName());
			object.put("paymentState", member.getPaymentState() == null ? "" : "1");
			Boolean isActive = Boolean.FALSE;
			if (MemberUtil.isActiveMember(member)) {
				isActive = Boolean.TRUE;
			}
			object.put("isActive", isActive);
			if (member.getUser() == null || StringUtils.isEmpty(member.getUser().getId())) {
				object.put("isBindUser", "false");
			} else {
				object.put("isBindUser", "true");
			}
			if (member.getMobile() != null && member.getMobile().length() == 11) {
				object.put("mobile", member.getMobile().substring(0, 3) + "****" + member.getMobile().substring(7, 11));
			} else {
				object.put("mobile", "");
			}
			if (member.getSafeMobile() != null && member.getSafeMobile().length() == 11) {
				object.put("safeMobile",
						member.getSafeMobile().substring(0, 3) + "****" + member.getSafeMobile().substring(7, 11));
			} else {
				object.put("safeMobile", "");
			}
			RESTResponse result = new RESTResponse("data", object);
			ServletUtils.writeResponse(response, result);
		}
	}

	// 验证会员是否有效
	@RequestMapping(value = "/isActiveMember", method = RequestMethod.GET)
	@ResponseBody
	public void isActiveMember(HttpServletResponse response) throws IOException {
		boolean isAct = MemberUtil.isActiveMember(UserUtils.getLoginMember());
		ServletUtils.writeResponse(response, new RESTResponse("data", isAct));
	}
	// @RequestMapping(value = "/{memberCode}", method = RequestMethod.GET)
	// @ResponseBody
	// public void get(@PathVariable("memberCode") String memberCode,
	// HttpServletResponse response)
	// throws IOException {
	// Member member = memberService.getByMemberCode(memberCode);
	// RestMember vo = new RestMember();
	// if(member!=null){
	// vo.setMemberCode(member.getMemberCode());
	// vo.setName(member.getName());
	// vo.setMobile(member.getMobile());;
	// }
	// ServletUtils.writeResponse(response, new RESTResponse("data",vo));
	// }

	/**
	 * 根据身份证号查询会员
	 * 
	 * @Author chaixueteng
	 * @2016年9月23日上午10:30:47
	 */
	@RequestMapping(value = "/searchMemberByCardNo", method = RequestMethod.GET)
	@ResponseBody
	public void searchMemberByCardNo(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restMemberService.searchMemberByCardNo(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 生成美容师会员
	 * 
	 * @Author chaixueteng
	 * @2016年9月23日上午10:30:47
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ResponseBody
	public void save(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restMemberService.save(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/getByQRCode", method = RequestMethod.GET)
	public void getByQRCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, restMemberService.getByQRCode(request));
	}

	@RequestMapping(value = "/getMember", method = RequestMethod.GET)
	@ResponseBody
	public RESTResponse getMember(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String memberCode = request.getParameter("memberCode");
		return memberService.getReferee(memberCode);
	}

}
