package com.cku.restful.v1.kennel.service;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentCartDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.entity.KennelOwnerChange;
import com.cku.oa.kennel.service.KennelOwnerChangeService;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.SMSChangePassword;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.restful.v1.kennel.model.RestKennelOwnerChange;
import com.cku.restful.v1.kennel.model.RestKennelOwnerChangeMoney;
import com.github.sd4324530.fastweixin.util.StrUtil;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Service
@Transactional(readOnly = true)
public class RestKennelOwnerChangeService {

	public static final String KENNEL_Y = "kennel_owner_change@Y";
	public static final String KENNEL_P = "kennel_owner_change@P";

	public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

	@Autowired
	private KennelDao kennelDao;

	@Autowired
	private MemberDao memberDao;

	@Autowired
	private SMSRemindService smsRemindService;

	@Autowired
	private PaymentCartService paymentCartService;

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@Autowired
	private KennelOwnerChangeService kennelOwnerChangeService;

	@Autowired
	private PaymentOrderService paymentOrderService;

	@Autowired
	private PaymentCartDao paymentCartDao;

	public RESTResponse check() {
		try {
			Member member = UserUtils.getLoginMember();
			Kennel kennel = kennelDao.getKennelByMemberCode(member.getMemberCode());
			if (kennel != null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您已有犬舍，不支持此项业务办理！");
			}
			KennelOwnerChange kennelOwnerChange = new KennelOwnerChange();
			kennelOwnerChange.setNewOwnerMemberCode(member.getMemberCode());
			List<KennelOwnerChange> lists = kennelOwnerChangeService.findList(kennelOwnerChange);

			for (KennelOwnerChange e : lists) {
				if ("2".equals(e.getPaymentState())) {
					if (("0".equals(e.getReviewState()))
							|| ("1".equals(e.getReviewState()) && "0".equals(e.getProcessState()))) {
						throw new Exception("您已申请犬舍所有人变更，正在审核处理中！");
					}
				} else {
					if (StrUtil.isNotBlank(e.getRunningNumber())) {
						// 查订单
						PaymentOrder order = paymentOrderService.get(e.getRunningNumber());
						// 如果订单已删除。报错提示
						if (order != null && "0".equals(order.getDelFlag())) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您已申请犬舍所有人变更,有未支付订单。");
						}
					} else {
						// 查购物车
						PaymentCart paymentCart = paymentCartDao.getByTableAndId("kennel_owner_change", e.getId());
						if (paymentCart != null) {
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您已申请犬舍所有人变更,购物车中有未支付订单！。");
						}
					}
				}
			}
			return new RESTResponse();
		} catch (Exception e) {
			return new RESTResponse(-1, e.getMessage());
		}

	}

	public RESTResponse getOwnerChange(String memberCode) {
		try {
			Member currentMember = UserUtils.getLoginMember();
			if (StrUtil.hasBlank(memberCode)) {
				throw new Exception("请输入变更犬舍原所有人会员号");
			}
			Member member = memberDao.getByMemberCode(memberCode);
			if (member == null) {
				throw new Exception("您输入的会员号有误，没有查询出结果！");
			}
			String loginTypeCurrent = StringUtils.isBlank(currentMember.getMemberSite()) ? "2"
					: currentMember.getMemberSite();
			String loginTypeNew = StringUtils.isBlank(member.getMemberSite()) ? "2" : member.getMemberSite();
			if (!loginTypeCurrent.equals(loginTypeNew)) {
				throw new Exception("您变更的犬舍类型和当前会员类型不属于同一俱乐部，无法变更！");
			}
			Kennel kennel = kennelDao.getKennelByMemberCode(memberCode);
			if (kennel == null || "3".equals(kennel.getReviewState())) {
				throw new Exception("该会员名下无犬舍信息，无法变更！");
			}
			
			// 如原犬舍有变更记录，且状态 非（未通过，已注销），则不允许再次变更
			List<KennelOwnerChange> changeList = kennelOwnerChangeService.findOriginApplyingChangeList(memberCode);
			if (!CollectionUtils.isEmpty(changeList) && changeList.size() > 0) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "该犬舍已有犬舍变更记录，无法变更！");
			}
			
			RestKennelOwnerChange restKennelOwnerChange = new RestKennelOwnerChange();
			restKennelOwnerChange.setEndTime(sdf.format(kennel.getEndTime()));
			restKennelOwnerChange.setMemberCode(member.getMemberCode());
			restKennelOwnerChange.setMemberName(member.getName());
			restKennelOwnerChange.setMobile(member.getMobile());
			restKennelOwnerChange.setName(kennel.getName());
			restKennelOwnerChange.setNameEn(kennel.getNameEn());
			if ("year".equals(kennel.getType())) {
				restKennelOwnerChange.setType("年度犬舍");
			} else if ("permanent".equals(kennel.getType())) {
				restKennelOwnerChange.setType("永久犬舍");
			}
			return new RESTResponse("data", restKennelOwnerChange);
		} catch (Exception e) {
			return new RESTResponse(-1, e.getMessage());
		}
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public RESTResponse getOwnerChangeCode(String memberCode, String mobile) {
		Kennel kennel = kennelDao.getKennelByMemberCode(memberCode);
		smsRemindService.sendOwnerChangeSMSCode(kennel, mobile);
		return new RESTResponse();
	}

	@Transactional(readOnly = false)
	public RestKennelOwnerChangeMoney post(String memberCode, String smsCode) {
		try {
			Member member = UserUtils.getLoginMember();
			Kennel kennel = kennelDao.getKennelByMemberCode(memberCode);
			if (kennel == null) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "该会员名下无犬舍信息，无法变更！");
			}
			checkSmsCode(kennel, smsCode);
			// 如原犬舍有变更记录，且状态 非（未通过，已注销），则不允许再次变更
			List<KennelOwnerChange> changeList = kennelOwnerChangeService.findOriginApplyingChangeList(memberCode);
			if (!CollectionUtils.isEmpty(changeList) && changeList.size() > 0) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "原犬舍已有犬舍变更记录，无法变更！");
			}

			// 判断申请人当前是否已有犬舍变更申请记录，有则不允许重复申请
			changeList = kennelOwnerChangeService.findNewApplyingChangeList(member.getMemberCode());
			if (!CollectionUtils.isEmpty(changeList) && changeList.size() > 0) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "存在处理中的犬舍变更记录，请勿重复申请！");
			}

			// 购物车
			String shortName = null;
			if ("year".equals(kennel.getType())) {
				shortName = KENNEL_Y;
			} else if ("permanent".equals(kennel.getType())) {
				shortName = KENNEL_P;
			}
			// 写入业务表
			KennelOwnerChange po = new KennelOwnerChange();
			po.setOriginOwnerMemberCode(kennel.getMemberCode());
			po.setKennelCode(kennel.getKennelCode());
			po.setNewOwnerMemberCode(member.getMemberCode());
			PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
			po.setPaymentMoney(paymentChargingItem.getPrice());
			po.setDelFlag("0");
			po.setReviewState("0");
			po.setPaymentState("1");
			kennelOwnerChangeService.save(po);
			// 写入购物车
			String businessOrderCode = IdGen.uuid();
			PaymentCart paymentCart = buildPaymentCart(po, shortName, businessOrderCode);
			paymentCartService.addToCart(paymentCart, "1084");

			RestKennelOwnerChangeMoney restKennelOwnerChange = new RestKennelOwnerChangeMoney();
			restKennelOwnerChange.setEndTime(sdf.format(kennel.getEndTime()));
			restKennelOwnerChange.setMemberCode(kennel.getMemberCode());
			restKennelOwnerChange.setMemberName(kennel.getMember().getName());
			restKennelOwnerChange.setMobile(kennel.getMember().getMobile());
			restKennelOwnerChange.setName(kennel.getName());
			restKennelOwnerChange.setNameEn(kennel.getNameEn());
			if ("year".equals(kennel.getType())) {
				restKennelOwnerChange.setType("年度犬舍");
			} else if ("permanent".equals(kennel.getType())) {
				restKennelOwnerChange.setType("永久犬舍");
			}
			restKennelOwnerChange.setPaymentMoney(paymentChargingItem.getPrice());
			restKennelOwnerChange.setShopId(paymentCart.getId());
			restKennelOwnerChange.setOriginOwnerMemberCode(kennel.getMemberCode());
			restKennelOwnerChange.setNewOwnerMemberCode(member.getMemberCode());

			restKennelOwnerChange
					.setOriginOwnerMemberName(Objects.nonNull(kennel.getMember()) ? kennel.getMember().getName() : "");
			restKennelOwnerChange.setNewOwnerMemberName(member.getName());
			return restKennelOwnerChange;
		} catch (ZAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ZAException(ZAErrorCode.ZA_ERROR, "犬舍变更失败");
		}
	}

	public void checkSmsCode(Kennel kennel, String smsCode) {
		String mobile = kennel.getMember().getMobile();
		SMSChangePassword oldSMS = (SMSChangePassword) CacheUtils.get("kennekOwnerChangeCache",
				"sms_kennnel_owner_change" + mobile);
		if (oldSMS == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请重新获取");
		}
		int time = (int) (300 - (System.currentTimeMillis() - oldSMS.getDate().getTime()) / 1000);
		if (time <= 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码无效，请重新获取");
		}
		if (!smsCode.equals(oldSMS.getKey())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码有误，请填写正确的变更授权验证码！");
		}
		// 校验通过后移除验证授权码
		CacheUtils.remove("kennekOwnerChangeCache", "sms_kennnel_owner_change" + mobile);
	}

	private PaymentCart buildPaymentCart(KennelOwnerChange po, String shortName, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("kennel_owner_change");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		// paymentCart.setToken(po.getToken());
		return paymentCart;
	}

//    public RESTResponse getKennelDetail(String memberCode,String smsCode){
//        try {
//
//            Member member =  memberDao.getByMemberCode(memberCode);
//            Kennel kennel = kennelDao.getKennelByMemberCode(memberCode);
//            //验证码
//            checkSmsCode(kennel,smsCode);
//            RestKennelOwnerChangeMoney restKennelOwnerChange = new RestKennelOwnerChangeMoney();
//            restKennelOwnerChange.setEndTime(sdf.format(kennel.getEndTime()));
//            restKennelOwnerChange.setMemberCode(member.getMemberCode());
//            restKennelOwnerChange.setMemberName(member.getName());
//            restKennelOwnerChange.setMobile(member.getMobile());
//            restKennelOwnerChange.setName(kennel.getName());
//            String shortName = null;
//            if("year".equals(kennel.getType())){
//                restKennelOwnerChange.setType("年度犬舍");
//                shortName = KENNEL_Y;
//            }else if("permanent".equals(kennel.getType())){
//                shortName = KENNEL_P;
//                restKennelOwnerChange.setType("永久犬舍");
//            }
//            PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
//            restKennelOwnerChange.setPaymentMoney(paymentChargingItem.getPrice());
//
//            return new RESTResponse("data",restKennelOwnerChange);
//        }catch (Exception e){
//            return new RESTResponse(-1,e.getMessage());
//        }
//    }
}
