package com.cku.restful.v1.dogNose.service;

import java.util.Date;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogNoseCheckinDao;
import com.cku.oa.dog.entity.DogNoseCheckin;
import com.cku.oa.sys.entity.user.Member;
import com.cku.partner.sys.model.PartnerLoginUserInfo;
import com.cku.restful.v1.dogNose.model.RestDogNoseCheckinRequest;
import com.cku.restful.v1.dogNose.model.RestDogNoseCheckinRequest.Device;
import com.cku.restful.v1.dogNose.model.RestDogNoseCheckinResponse;
import com.cku.restful.v1.dogNose.model.RestDogNoseNotifyRequest;
import com.cku.restful.v1.dogNose.model.RestDogNoseNotifyResponse;
import com.thinkgem.jeesite.common.persistence.BaseEntity;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Service
@Transactional(readOnly = true)
public class RestDogNoseCheckinService {
	
	@Autowired
	private DogNoseCheckinDao dogNoseCheckinDao;
	
	@Autowired
	private UserDao userDao;
	
	/**
	 * 鼻纹登记
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@Transactional(readOnly = false)
	public ResultDto<RestDogNoseCheckinResponse> noseCheckin(RestDogNoseCheckinRequest request) throws Exception {
		if(Objects.isNull(request.getBizType())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"业务类型不能为空");
		}
		
		if(Objects.isNull(request.getDevice())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"设备信息不能为空");
		}
		
		if(Objects.isNull(request.getDevice().getPlatform())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"设备平台不能为空");
		}
		String operatorId = "";
		String operatorCode = "";
		if(request.getClubFlag()) {
			PartnerLoginUserInfo partner = UserUtils.getLoginPartner();
			operatorId = partner.getUserId();
			operatorCode = partner.getMemberCode();
		}else {
			Member member = UserUtils.getLoginMember();
			operatorId = member.getUserId();
			operatorCode = member.getMemberCode();
		}
		if(StringUtils.isBlank(operatorId)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"获取登录用户信息失败");
		}
		User user = userDao.get(operatorId);
		if(Objects.isNull(user)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"查询用户信息失败");
		}
		DogNoseCheckin dogNoseCheckin = new DogNoseCheckin();
		dogNoseCheckin.setBizId(request.getBizId());
		dogNoseCheckin.setBizType(request.getBizType().code());
		Device device = request.getDevice();
		if(Objects.nonNull(device)) {
			if("IOS".equals(StringUtils.isBlank(request.getDevice().getPlatform())?"":request.getDevice().getPlatform().toUpperCase())) {
				dogNoseCheckin.setDeviceInformation("IOS暂不支持设备信息记录");
			}else {
				dogNoseCheckin.setDeviceInformation(device.getInformation());
			}
			dogNoseCheckin.setDeviceModel(device.getModel());
			dogNoseCheckin.setDeviceNumber(device.getNumber());
			dogNoseCheckin.setDevicePlatform(device.getPlatform());
			dogNoseCheckin.setDeviceVersion(device.getVersion());
		}
		dogNoseCheckin.setId(IdGen.uuid());
		dogNoseCheckin.setNoseId(("android".equals(device.getPlatform().toLowerCase())?"9A":"9I")+IdGen.uuid());
//		dogNoseCheckin.setNoseCode(null);
		dogNoseCheckin.setCreateBy(user);
		dogNoseCheckin.setCreateDate(new Date());
		dogNoseCheckin.setDelFlag(BaseEntity.DEL_FLAG_NORMAL);
	
		dogNoseCheckin.setOperatorCode(operatorCode);
		dogNoseCheckin.setOperatorId(operatorId);
		dogNoseCheckin.setOperatorTime(new Date());
		int row = dogNoseCheckinDao.insert(dogNoseCheckin);
		if(row == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"获取鼻纹ID失败，请重试！");
		}
		return ResultDto.success(new RestDogNoseCheckinResponse(dogNoseCheckin.getNoseId()));
	}
	
	/**
	 * 鼻纹登记回调
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@Transactional(readOnly = false)
	public ResultDto<RestDogNoseNotifyResponse> noseNotify(RestDogNoseNotifyRequest request) throws Exception {
		
		if(StringUtils.isBlank(request.getNoseId())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"鼻纹ID不能为空");
		}
		if(Objects.isNull(request.getCheckinStatus())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"识别状态不能为空");
		}
		
		DogNoseCheckin dogNoseCheckin = dogNoseCheckinDao.selectByNoseId(request.getNoseId());
		if(Objects.isNull(dogNoseCheckin)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"未查询到鼻纹登记记录，请重新识别！");
		}
		dogNoseCheckin.setCheckinStatus(request.getCheckinStatus().code());
		dogNoseCheckin.setCheckinFailReason(request.getCheckinFailReason());
		dogNoseCheckin.setNotifyTime(new Date());
		dogNoseCheckin.setUpdateBy(new User("-1"));
		dogNoseCheckin.setUpdateDate(new Date());
		int row = dogNoseCheckinDao.update(dogNoseCheckin);
		if(row == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"更新鼻纹信息失败，请重试！");
		}
		RestDogNoseNotifyResponse resp = new RestDogNoseNotifyResponse();
		resp.setNoseId(dogNoseCheckin.getNoseId());
		return ResultDto.success(resp);
	}

}
