/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogColorMarkDao;
import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogDnaService;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.service.KennelAllianceService;
import com.cku.oa.show.dao.ShowResultsDao;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.DateUtils;
import com.cku.oa.tcb.service.TcbKennelService;
import com.cku.restful.v1.dog.model.RestDogNewborn;
import com.cku.restful.v1.dog.vo.DogBloodCheckVO;
import com.cku.restful.v1.finance.service.DogNewbornDeleteService;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * 配种证明Service
 *
 * @author zhuoHeng
 * @version 2016-08-02
 */
@Service
@Transactional(readOnly = true)
public class RestDogNewbornService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ALL_2MOUNTH_IN = "dog_newborn@All_2mounth_in";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ALL_2MOUNTH_OUT = "dog_newborn@All_2mounth_out";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO_2MOUNTH_IN = "dog_newborn@Zangao_2mounth_in";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO_2MOUNTH_OUT = "dog_newborn@Zangao_2mounth_out";

	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private DogService dogService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private KennelAllianceService kennelAllianceService;
	@Autowired
	public TcbKennelService tcbKennelService;
	@Autowired
	public DogColorMarkDao dogColorMarkDao;
	@Autowired
	public DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	public DogSemenDao dogSemenDao;
	@Autowired
	public DogNewbornDeleteService dogNewbornDeleteService;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	public PaymentOrderService paymentOrderService;
	@Autowired
	public RestDogDloodDnaService restDogDloodDnaService;
	@Autowired
	public DogBloodSaveService dogBloodSaveService;
	@Autowired
	private DogNewbornDao dogNewbornDao;
	@Autowired
	private ShowResultsDao showResultsDao;
	@Autowired
	private DogDnaService dogDnaService;
	@Autowired
	private SysCouponService sysCouponService;
	
	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	

	private static final String COUPON_TARGET_MEMBERDOG = "memberdog";

	public RESTResponse get(String id) {
		Member member = UserUtils.getLoginMember();
		DogNewborn dogNewborn = dogNewbornService.get(id);

		if (dogNewborn == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!dogNewborn.getMdogOwnerCode().equals(member.getMemberCode())
				&& !dogNewborn.getFdogOwnerCode().equals(member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		// 校验母犬主为有效专业会员
		dogBirthCertificateService.validateMDogOwner(member.getMemberCode());
		// 校验母犬主为有效犬舍
		dogBirthCertificateService.validateMDogOwnerKennel(member.getMemberCode());
		RestDogNewborn vo = new RestDogNewborn();
		BeanUtil.copyProperties(vo, dogNewborn, "yyyy-MM-dd");
		vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
		Dog maleDog = dogService.getByPedigreeCertifiedCode(dogNewborn.getMalePedigreeCertified());
		Dog femaleDog = dogService.getByPedigreeCertifiedCode(dogNewborn.getFemalePedigreeCertified());
		if (StringUtils.isBlank(dogNewborn.getDogBreed())) {
			vo.setDogBreed(maleDog.getDogBreed());
		}
		// true标识淘宠犬舍
		boolean tcbKennel = tcbKennelService.isUrgentFree(dogNewborn.getFdogOwnerCode());
		vo.setTcbKennel(tcbKennel);
		DogType dogType = dogTypeService.getByDogBreedCode(maleDog.getDogBreed());
		String breedCnName = "";
		if (dogType == null) {
			breedCnName = dogTypeService.getUnMapBreedCnName(maleDog.getDogBreed());
		} else {
			breedCnName = dogType.getBreedCnName();
		}
		vo.setDogBreedName(breedCnName);
		if (StringUtils.isNotBlank(maleDog.getColorFlag())) {
			DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(maleDog.getColorFlag());
			if (dogColorMark != null) {
				vo.setMaleDogColorFlag(dogColorMark.getDogColorMarkCn());
			}
		}
		if (StringUtils.isNotBlank(femaleDog.getColorFlag())) {
			DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(femaleDog.getColorFlag());
			if (dogColorMark != null) {
				vo.setFemaleDogColorFlag(dogColorMark.getDogColorMarkCn());
			}
		}
		return new RESTResponse("data", vo);
	}

	public RESTResponse getRefundList(String ids) {
		if (StringUtils.isEmpty(ids))
			return new RESTResponse("data", new ArrayList<RestDogNewborn>());
		Member member = UserUtils.getLoginMember();
		DogNewborn example = new DogNewborn();
		example.setId(ids);
		example.setMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		List<DogNewborn> lst = dogNewbornService.findList(example);
		List<RestDogNewborn> list = new ArrayList<RestDogNewborn>();
		for (DogNewborn dogNewborn : lst) {
			RestDogNewborn vo = new RestDogNewborn();
			BeanUtil.copyProperties(vo, dogNewborn, "yyyy-MM-dd");
			vo.setReviewStateCode(vo.getReviewState());
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "dog_birth_certificate_review_state", ""));
			vo.setIsHaveDogBirthCertificate(
					dogBirthCertificateDao.countByFmdogBreedCertifiedCode(vo.getBreedCertifiedCode()) > 0 ? "1" : "0");
			if (StringUtils.isNotBlank(dogNewborn.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dogNewborn.getDogBreed());
				if (dogType != null)
					vo.setDogBreedName(dogType.getBreedCnName());
			}
			list.add(vo);
		}
		return new RESTResponse("data", list);

	}

	private void validateRefundState(DogNewborn po, RestDogNewborn vo) {
		boolean canCanceled = paymentOrderService.getCanCanceledByBusinessIdAOrderCode(po.getId(),
				po.getRunningNumber());
		if (vo == null) {
			if (!canCanceled)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已申请退费业务，无法操作");
		} else {
			vo.setCanEdit(canCanceled);
		}
	}

	public RESTResponse getList(HttpServletRequest request) {

		Member member = UserUtils.getLoginMember();

		// 获取参数
		String breedCertifiedCode = request.getParameter("breedCertifiedCode");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 审核通过的数据过滤（宠爱王国app使用）
		String passState = request.getParameter("passState");
		// 公母犬主配种证明列表数据过滤（宠爱王国app使用）
		String dogOwnerGender = request.getParameter("dogOwnerGender");

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		DogNewborn example = new DogNewborn();
		// 设置分页参数
		Page<DogNewborn> page = new Page<DogNewborn>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(breedCertifiedCode)) {
			example.setBreedCertifiedCode(breedCertifiedCode);
		}

		// 审核通过标识（宠爱王国使用，因需要过滤出审核通过后的数据）
		if ("true".equals(passState)) {
			example.setReviewState("1");
		}
		// 公母犬业务列表过滤（宠爱王国使用，因需要展示不同的列表）
		if ("male".equals(dogOwnerGender)) {
			example.setMdogOwnerCode(member.getMemberCode());
		} else if ("female".equals(dogOwnerGender)) {
			example.setFdogOwnerCode(member.getMemberCode());
			// h5母犬查询标记位
			// 1） 当前会员为繁殖人（母犬主人）的配种证明列表
			// 2） 配种证明审核状态为已通过
			// 3） 配种证明尚未申请登记卡（出生纸）

			String canApplyDogBirthCertificateFlag = request.getParameter("canApplyDogBirthCertificate");
			if ("1".equals(canApplyDogBirthCertificateFlag)) {
				example.setCanApplyDogBirthCertificateFlag("1");
			}
		}
		// 根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if (StringUtils.isBlank(example.getDogBreed())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreed() + "'");
		}
		// 查询并组装返回对象
		Page<DogNewborn> result = dogNewbornService.findPage(page, example);
		List<DogNewborn> dogNewbornList = result.getList();
		List<RestDogNewborn> list = new ArrayList<RestDogNewborn>();
		for (DogNewborn dogNewborn : dogNewbornList) {
			RestDogNewborn vo = new RestDogNewborn();
			BeanUtil.copyProperties(vo, dogNewborn, "yyyy-MM-dd");
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "dog_birth_certificate_review_state", ""));
			// 根据配种证明号查询是否有未删除的出生证明记录，没有就可以申请
			String isHaveDogBirthCertificate = "0";
			String isShowZW = "0";
			if (dogBirthCertificateDao.countByFmdogBreedCertifiedCode(vo.getBreedCertifiedCode()) > 0) {
				isHaveDogBirthCertificate = "1";
				isShowZW = "1";
			}
			// 20-08-10增加不能申请判断： 登记卡配种证明内有近亲繁殖取DNA标记 或者 冷冻精子提交的配种证明 或者 办理时犬只年龄在1-2岁之间的青年犬
			if ("1".equals(dogNewborn.getKinGetDna()) || StringUtils.isNotBlank(dogNewborn.getSemenCode())) {
				isShowZW = "1";
			}
			vo.setIsShowZW(isShowZW);
			vo.setIsHaveDogBirthCertificate(isHaveDogBirthCertificate);
			if (StringUtils.isNotBlank(dogNewborn.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dogNewborn.getDogBreed());
				if (dogType != null) {
					vo.setDogBreedName(dogType.getBreedCnName());
				}
			}
			list.add(vo);
		}

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
		list.forEach(a -> {
			a.setCanEdit(!map.keySet().contains(a.getId()));
		});

		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestDogNewborn>(list, count));
	}

	@Transactional(readOnly = false)
	public RESTResponse post(HttpServletRequest request, String json) {
		// 获取参数
		RestDogNewborn vo = BeanUtil.toBean(json, RestDogNewborn.class);
		// 参数校验
		validateParameter(vo);
		// 检查双亲血样留存记录
		DogBloodCheckVO c1 = dogBloodSaveService.checkDna(vo.getFemalePedigreeCertified(), false);
		if (!c1.isDogDloodDna()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬没有DNA位点分析！");
		}

		DogBloodCheckVO c2 = dogBloodSaveService.checkDna(vo.getMalePedigreeCertified(), false);
		if (!c2.isDogDloodDna()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "公犬没有DNA位点分析！");
		}

		// 构造持久对象
		DogNewborn po = buildPo(vo);
		// 业务校验
		dogNewbornService.validateBusiness(po);
		// 写入业务表
		dogNewbornService.save(po);
		// 使用精子进行配种需要会写精子表数据
		if (StringUtils.isNotBlank(po.getSemenCode())) {
			Map<String, Object> map = new HashMap<>();
			map.put("semenCode", po.getSemenCode().split(","));
			map.put("breedCertifiedCode", po.getBreedCertifiedCode());
			dogSemenDao.setBreedCertifiedCode(map);
		}
		// 写入购物车
		String businessOrderCode = IdGen.uuid();
		PaymentCart paymentCart = buildPaymentCart(po);
		paymentCart.setBusinessOrderCode(businessOrderCode);
		paymentCartService.addToCart(paymentCart, "1000");
		// 宠爱王国需接受业务信息返回进行展示
		BeanUtil.copyProperties(vo, po, "yyyy-MM-dd");
		vo.setCartIds(paymentCart.getId());
		return new RESTResponse("data", vo);
	}

	@Transactional(readOnly = false)
	public RESTResponse put(String json) {
		// 获取参数
		RestDogNewborn vo = BeanUtil.toBean(json, RestDogNewborn.class);
		Member member = UserUtils.getLoginMember();
		// 参数校验
		putValidateParameter(vo);
		DogNewborn po = dogNewbornService.get(vo.getId());
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getMdogOwnerCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if ("1".equals(po.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务记录已通过审核，不允许修改");
		}
		if (StringUtils.isNotBlank(po.getSemenCode()) && StringUtils.isBlank(vo.getSemenCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "精子编号不能为空");
		}
		this.validateRefundState(po, null);
		Date createDate;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		try {
			createDate = sdf.parse(sdf.format(po.getCreateDate()));
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "日期有误");
		}
		boolean isIn2Mounth = dogNewbornService.isInXMounth(po.getBreedDate(), createDate, 2);
		Date breedDate = null;
		try {
			breedDate = new SimpleDateFormat("yyyy-MM-dd").parse(vo.getBreedDate());
		} catch (ParseException e) {
			e.printStackTrace();
		}
		if (StringUtils.isBlank(po.getSemenCode()) && isIn2Mounth) {
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(createDate);
			calendar.add(Calendar.MONTH, -2);
			if (calendar.getTime().after(breedDate)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期有误，配种日期与订单提交日期必须在俩个月内");
			}
		}
		if (StringUtils.isBlank(po.getSemenCode()) && !isIn2Mounth) {
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(createDate);
			calendar.add(Calendar.MONTH, -2);
			calendar.add(Calendar.DATE, -1);
			if (calendar.getTime().before(breedDate)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期有误，配种日期与订单提交日期必须在俩个月以上");
			}
		}
		// 设置能修改的字段，只能修改公犬血统证书号和配种日期
		Dog fatherDog = dogService.getByPedigreeCertifiedCode(vo.getMalePedigreeCertified());
		if (fatherDog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号有误");
		}
		if (!member.getMemberCode().equals(fatherDog.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号有误");
		}
		po.setMaleDogName(fatherDog.getNameCn());
		po.setMalePedigreeCertified(fatherDog.getPedigreeCertifiedCode());
		po.setBreedDate(breedDate);
		if (!po.getDogBreed().equals(fatherDog.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "不允许变更父犬犬种");
		}
		if (StringUtils.isNotBlank(vo.getSemenCode())) {
			// 清空原来使用的精子
			dogNewbornDeleteService.clearDogSemen(po.getId());
			po.setSemenCode(vo.getSemenCode());
		}
		// 修改后改为未审核状态
		po.setReviewState("0");
		// 业务校验
		dogNewbornService.validateBusiness(po);
		// 写入业务表
		dogNewbornService.save(po);
		// 设置新的精子
		if (StringUtils.isNotBlank(vo.getSemenCode())) {
			// 使用精子进行配种需要会写精子表数据
			Map map = new HashMap<String, Object>();
			map.put("semenCode", po.getSemenCode().split(","));
			map.put("breedCertifiedCode", po.getBreedCertifiedCode());
			dogSemenDao.setBreedCertifiedCode(map);
		}
		return new RESTResponse();
	}

	private void putValidateParameter(RestDogNewborn vo) {
		if (StringUtils.isBlank(vo.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id为空");
		}
		if (StringUtils.isBlank(vo.getMalePedigreeCertified())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号为空");
		}
		if (StringUtils.isBlank(vo.getBreedDate())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期为空");
		}
		Date date = null;
		try {
			date = new SimpleDateFormat("yyyy-MM-dd").parse(vo.getBreedDate());
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期格式有误");
		}
		if (new Date().before(date)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期必须小于当前日期");
		}
	}

	/**
	 *
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午4:09:54
	 */
	private void validateParameter(RestDogNewborn vo) {
		if (StringUtils.isBlank(vo.getMalePedigreeCertified())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号为空");
		}
		if (StringUtils.isBlank(vo.getFemalePedigreeCertified())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母血统证书号为空");
		}
		if (StringUtils.isBlank(vo.getBreedDate())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期为空");
		}
		if (StringUtils.isBlank(vo.getUrgent())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "加急状态为空");
		}
		if (!"0".equals(vo.getUrgent()) && !"1".equals(vo.getUrgent())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "加急状态只能为0，1");
		}
		Date date = null;
		try {
			date = new SimpleDateFormat("yyyy-MM-dd").parse(vo.getBreedDate());
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期格式有误");
		}
		if (new Date().before(date)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期必须小于当前日期");
		}
	}

	/**
	 *
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	public DogNewborn buildPo(RestDogNewborn vo) {
		DogNewborn po = new DogNewborn();
		Dog fatherDog = dogService.getByPedigreeCertifiedCode(vo.getMalePedigreeCertified());
		Dog motherDog = dogService.getByPedigreeCertifiedCode(vo.getFemalePedigreeCertified());
		if (fatherDog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号有误");
		}
		if (motherDog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母血统证书号有误");
		}
		Member member = UserUtils.getLoginMember();
		Member fatherMember = memberService.getByMemberCode(fatherDog.getMemberCode());
		Member motherMember = memberService.getByMemberCode(motherDog.getMemberCode());
		po.setMaleDogOwner(fatherMember.getName());
		po.setMdogOwnerCode(fatherMember.getMemberCode());
		po.setFemaleDogOwner(motherMember.getName());
		po.setFdogOwnerCode(motherMember.getMemberCode());
		po.setMaleDogName(fatherDog.getNameEn());
		po.setMalePedigreeCertified(fatherDog.getPedigreeCertifiedCode());
		po.setFemaleDogName(motherDog.getNameEn());
		po.setFemalePedigreeCertified(motherDog.getPedigreeCertifiedCode());
		try {
			po.setBreedDate(new SimpleDateFormat("yyyy-MM-dd").parse(vo.getBreedDate()));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		po.setDogBreed(fatherDog.getDogBreed());
		// 获取配种证明收费项
		PaymentChargingItem paymentChargingItem = getPaymentChargingItem(po.getBreedDate(), vo.getUrgent(),
				fatherDog.getPedigreeCertifiedCode(), motherDog.getPedigreeCertifiedCode());
		po.setPaymentChargingItem(paymentChargingItem);
		po.setPrice(paymentChargingItem.getPrice());
		// 只有协会打印
		po.setPrintType("1");
		po.setUrgent(vo.getUrgent());
		if (StringUtils.isNotBlank(vo.getSemenCode())) {
			// 根据精子编号查询会员信息
			DogSemen dogSemen = dogSemenDao.getBySemenCode(vo.getSemenCode().split(",")[0]);
			// 繁殖人为精子拥有者
			po.setMaleDogOwner(dogSemen.getMemberName());
			po.setMdogOwnerCode(dogSemen.getMemberCode());
			po.setSemenCode(vo.getSemenCode());
			po.setSemenOwnerMemberCode(dogSemen.getMemberCode());
		} else {
			if (!member.getMemberCode().equals(fatherDog.getMemberCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号有误");
			}
		}
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setProcessState("0");
		// 生成配种证明编号
		po.setBreedCertifiedCode(dogNewbornService.getBreedCertifiedCode(po));
		po.setArea(motherMember.getProvince() + motherMember.getCity());
		po.setToken(vo.getToken());
		return po;
	}

	private PaymentCart buildPaymentCart(DogNewborn po) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = po.getPaymentChargingItem();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(po.getPrice());
		paymentCart.setTotalPrice(po.getPrice());
		paymentCart.setBusinessTable("dog_newborn");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setToken(po.getToken());
		return paymentCartService.addBusinessManage(paymentCart, "1000");// 所属业务类型
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String breedDate = request.getParameter("breedDate");
		String urgent = request.getParameter("urgent");
		String malePedigreeCertified = request.getParameter("malePedigreeCertified");
		String femalePedigreeCertified = request.getParameter("femalePedigreeCertified");
		// 参数校验
		if (StringUtils.isBlank(breedDate)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期为空");
		}
		if (StringUtils.isBlank(urgent)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "加急状态为空");
		}
		if (!"0".equals(urgent) && !"1".equals(urgent)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "加急状态只能为0或1");
		}
		if (StringUtils.isBlank(malePedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号为空");
		}
		if (StringUtils.isBlank(femalePedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母血统证书号为空");
		}
		Date date = null;
		try {
			date = new SimpleDateFormat("yyyy-MM-dd").parse(breedDate);
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期格式有误");
		}
		if (new Date().before(date)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期必须小于当前日期");
		}
		// // 获取价格
		// int monthAge = getMonthAge(new Date(), date);
		// String shortName = "";
		// if (monthAge < 2) {
		// shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL_2MOUNTH_IN;
		// } else {
		// shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL_2MOUNTH_OUT;
		// }
		// PaymentChargingItem paymentChargingItem = paymentChargingItemService
		// .getByShortName(shortName);
		// Double priceDouble = Double.valueOf(paymentChargingItem.getPrice());
		// //加急加收30%的费用,犬舍联盟的加急免收30%
		// if
		// ("1".equals(urgent)&&!kennelAllianceService.isKennelAlliance(dogNewborn.getFdogOwnerCode()))
		// {
		// priceDouble = priceDouble * 1.3;
		// }
		// 获取配种证明收费项
		PaymentChargingItem paymentChargingItem = getPaymentChargingItem(date, urgent, malePedigreeCertified,
				femalePedigreeCertified);
		JSONObject jo = new JSONObject();
		jo.put("price", paymentChargingItem.getPrice());
		return new RESTResponse("data", jo);
	}

	/**
	 * @description: 获取配种证明收费项
	 * @author: laiguanglong
	 * @date: 2016/12/29 17:55
	 */
	private PaymentChargingItem getPaymentChargingItem(Date breedDate, String urgent, String malePedigreeCertified,
			String femalePedigreeCertified) {
		Dog fatherDog = dogService.getByPedigreeCertifiedCode(malePedigreeCertified);
		Dog motherDog = dogService.getByPedigreeCertifiedCode(femalePedigreeCertified);
		if (fatherDog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号有误");
		}
		if (motherDog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母血统证书号有误");
		}
		// 获取价格
		boolean isIn2Mounth = DateUtils.isInXMounth(breedDate, 2);
		String shortName = "";
		if ("230".equals(fatherDog.getDogBreed())) {
			if (isIn2Mounth) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO_2MOUNTH_IN;
			} else {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO_2MOUNTH_OUT;
			}
		} else {
			if (isIn2Mounth) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL_2MOUNTH_IN;
			} else {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL_2MOUNTH_OUT;
			}
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		Double priceDouble = Double.valueOf(paymentChargingItem.getPrice());
		if ("1".equals(urgent) && !kennelAllianceService.isUrgentFree(motherDog.getMemberCode())) {
			priceDouble = priceDouble * 1.3;
			paymentChargingItem.setPrice(priceDouble.toString());
		}
		return paymentChargingItem;
	}

	/**
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2016年12月29日 上午9:20:08
	 */
	public RESTResponse orderDetail(String id) {

		DogNewborn dogNewborn = dogNewbornService.get(id);

		if (dogNewborn == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		RestDogNewborn vo = new RestDogNewborn();
		BeanUtil.copyProperties(vo, dogNewborn, "yyyy-MM-dd");
		Dog dog = dogService.getByPedigreeCertifiedCode(dogNewborn.getMalePedigreeCertified());
		if (StringUtils.isBlank(dogNewborn.getDogBreed())) {
			vo.setDogBreed(dog.getDogBreed());
		}
		DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
		String breedCnName = "";
		if (dogType == null) {
			breedCnName = dogTypeService.getUnMapBreedCnName(dog.getDogBreed());
		} else {
			breedCnName = dogType.getBreedCnName();
		}
		vo.setDogBreedName(breedCnName);
		Map<String, String> map = new HashMap<>();
		map.put("key1", "公犬主人：" + vo.getMaleDogOwner());
		map.put("key2", "公犬证书号：" + vo.getMalePedigreeCertified());
		map.put("key3", "母犬主人：" + vo.getFemaleDogOwner());
		map.put("key4", "母犬证书号：" + vo.getFemalePedigreeCertified());
		map.put("key5", "配犬编号：" + vo.getBreedCertifiedCode());
		map.put("key6", "配种日期：" + vo.getBreedDate());
		return new RESTResponse("data", map);
	}

	/**
	 * @Description：根据配种证明编号查询配种信息
	 * @author: zhuoHeng
	 * @version: 2017年1月5日 下午3:57:11
	 */
	public RESTResponse byBreedCertifiedCode(String breedCertifiedCode) {
		DogNewborn dogNewborn = dogNewbornService.getBybreedCertifiedCode(breedCertifiedCode);
		RestDogNewborn vo = new RestDogNewborn();
		BeanUtil.copyProperties(vo, dogNewborn, "yyyy-MM-dd");
		Dog dog = dogService.getByPedigreeCertifiedCode(dogNewborn.getMalePedigreeCertified());
		DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
		Map<String, String> map = new HashMap<>();
		map.put("key1", "犬主人：" + vo.getFemaleDogOwner());
		String breedCnName = "";
		if (dogType == null) {
			breedCnName = dogTypeService.getUnMapBreedCnName(dog.getDogBreed());
		} else {
			breedCnName = dogType.getBreedCnName();
		}
		map.put("key2", "犬种：" + breedCnName);
		map.put("key3", "出生日期：" + vo.getBirthday());
		map.put("key4", "配种证明编号：" + vo.getBreedCertifiedCode());
		return new RESTResponse("data", map);
	}

	/**
	 * @description: 根据犬只精子号获取犬只信息
	 * @author: laiguanglong
	 * @date: 2017/9/5 13:51
	 */
	public RESTResponse getDogBySemenCode(HttpServletRequest request) {
		String semenCode = request.getParameter("semenCode");
		String id = request.getParameter("id");
		if (StringUtils.isBlank(semenCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "精子编号为空");
		}
		List<String> semenCodeList = null;
		if (StringUtils.isNotBlank(id)) {
			DogNewborn po = dogNewbornService.get(id);
			if (po != null && StringUtils.isNotBlank(po.getSemenCode())) {
				semenCodeList = Arrays.asList(po.getSemenCode().split(","));
			}
		}
		Dog dog = dogNewbornService.validataSemenCode(semenCode, semenCodeList,
				UserUtils.getLoginMember().getMemberCode());
		// 校验犬只是否能办理当前登录类型的业务
		loginServerService.validDogType(dog);
		dogNewbornService.validateFatherDog(dog, semenCode, null, "vip");
		JSONObject data = new JSONObject();
		data.put("pedigreeCertifiedCode", getString(dog.getPedigreeCertifiedCode()));
		data.put("dogOwner", getString(dog.getDogOwner()));
		data.put("nameEn", getString(dog.getNameEn()));
		data.put("identificationFlag", getString(dog.getIdentificationFlag()));
		data.put("birthdate", getString(com.cku.util.DateUtils.dateToStr(dog.getBirthdate())));
		String colorFlag = "";
		if (StringUtils.isNotBlank(dog.getColorFlag())) {
			DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dog.getColorFlag());
			if (dogColorMark != null) {
				colorFlag = dogColorMark.getDogColorMarkCn();
			}
		}
		data.put("colorFlag", getString(colorFlag));
		data.put("dogBreed", getString(dogTypeService.getBreedCnName(dog.getDogBreed())));// 犬种
		data.put("dogSemenList", semenCode.split(","));// 精子
		return new RESTResponse("data", data);
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}

	public RESTResponse isDnaParentsCompare(String id) {
		if (StringUtils.isBlank(id)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明ID为空");
		}
		DogNewborn dogNewborn = dogNewbornService.get(id);
		if (dogNewborn == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种证明ID不对");
		}
		Dog fdog = dogService.getByPedigreeCertifiedCode(dogNewborn.getFemalePedigreeCertified(), true);
		Dog mdog = dogService.getByPedigreeCertifiedCode(dogNewborn.getMalePedigreeCertified(), true);
		boolean flag = false;
		if (dogDnaService.isHaveDogDna(fdog.getId()) && dogDnaService.isHaveDogDna(mdog.getId())) {
			flag = true;
		}
		if (!flag && StringUtils.isNotBlank(dogNewborn.getBreedCertifiedCode())) {
			// 使用冷冻精子进行配种的要可以选双亲比对
			if (StringUtils.isNotBlank(dogNewborn.getSemenCode())) {
				flag = true;
			}
		}
		return new RESTResponse("data", flag);

	}
	
	private void validate(RestDogNewborn vo) {
		// 参数校验
		validateParameter(vo);
		// 检查双亲血样留存记录
		DogBloodCheckVO c1 = dogBloodSaveService.check(vo.getFemalePedigreeCertified(), false);
		if (!c1.isDogDloodDna()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬没有血样留存！");
		}

		DogBloodCheckVO c2 = dogBloodSaveService.check(vo.getMalePedigreeCertified(), false);
		if (!c2.isDogDloodDna()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "公犬没有血样留存！");
		}
	}

	@Transactional(readOnly = false)
	public RESTResponse getPriceInfo(String json) throws Exception {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		RestDogNewborn vo = BeanUtil.toBean(json, RestDogNewborn.class);
		// 参数校验
		validate(vo);
		// 组装返回对象
		JSONObject jo = new JSONObject();
		JSONArray ja = new JSONArray();
		// 获取配种证明收费项
		boolean isIn2Mounth = DateUtils.isInXMounth(sdf.parse(vo.getBreedDate()), 2);
		Dog fatherDog = dogService.getByPedigreeCertifiedCode(vo.getMalePedigreeCertified());
		String shortName = "";
		if ("230".equals(fatherDog.getDogBreed())) {
			if (isIn2Mounth) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO_2MOUNTH_IN;
			} else {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO_2MOUNTH_OUT;
			}
		} else {
			if (isIn2Mounth) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL_2MOUNTH_IN;
			} else {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL_2MOUNTH_OUT;
			}
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		String productPrice = paymentChargingItem.getPrice();
		Double urgentFee = new Double("0");
		if ("1".equals(vo.getUrgent())) {
			urgentFee = Double.parseDouble(productPrice) * 0.3;
			// 加急
			JSONObject urgentJo = new JSONObject();
			urgentJo.put("name", "加急办理");
			urgentJo.put("info", "1天完成审批，增加30%手续费");
			urgentJo.put("price", urgentFee.toString());
			ja.add(urgentJo);
			if (kennelAllianceService.isUrgentFree(vo.getFdogOwnerCode())) {
				// 免加急费
				JSONObject urgentFreeJo = new JSONObject();
				urgentFreeJo.put("name", "免加急费");
				urgentFreeJo.put("info", "犬舍联盟免加急费");
				urgentFreeJo.put("price", "-" + urgentFee.toString());
				ja.add(urgentFreeJo);
				urgentFee= new Double("0");
			}
		}

		jo.put("other", ja);
		jo.put("totalPrice",  String.valueOf(new Double(productPrice)+urgentFee));
		// 判断产品类型
		jo.put("productName", "配种证明登记费");
		jo.put("productNum", "1");
		jo.put("productPrice", productPrice);
		//有无优惠券
		Page<SysCoupon> result = getCoupons(member.getMemberCode(), vo.getBreedDate(), 1, 10);
		jo.put("isCoupon", result.getCount()>0);
		return new RESTResponse("data", jo);
	}
	
	
	@Transactional(readOnly = false)
	public Page<SysCoupon> getCoupons(String memberCode,String breedDate,int pageNoInt,int pageSizeInt) throws Exception {
		// 设置参数
		SysCoupon example = new SysCoupon();
		example.setState("0");
		example.setMemberCode(memberCode);
		List<String> targetList = new ArrayList<>();
//		boolean isIn2Mounth = DateUtils.isInXMounth(sdf.parse(breedDate), 2);
		// 都可用memberdog优惠券
		targetList.add(COUPON_TARGET_MEMBERDOG);
		example.setTargetList(targetList);
		Page<SysCoupon> result = sysCouponService.findPage(new Page<SysCoupon>(pageNoInt, pageSizeInt), example);
		return result;
	}
	
	@Transactional(readOnly = false)
	public RESTResponse getTotalPrice(String json) throws Exception {
		// 获取参数
		RestDogNewborn vo = BeanUtil.toBean(json, RestDogNewborn.class);
		// 参数校验
		validate(vo);
		// 获取配种证明收费项
		PaymentChargingItem paymentChargingItem = getPaymentChargingItem(sdf.parse(vo.getBreedDate()), vo.getUrgent(),
				vo.getMalePedigreeCertified(), vo.getFemalePedigreeCertified());
		String productPrice = paymentChargingItem.getPrice();
		if( StringUtils.isNotBlank(vo.getCouponId())) {
			SysCoupon coupon = sysCouponService.getCouponAndCheck(vo.getCouponId());
			BigDecimal couponBD = new BigDecimal(coupon.getFacePrice());
			BigDecimal productPriceBD = new BigDecimal(productPrice);
			BigDecimal totalPrice=productPriceBD.subtract(couponBD);
			if(totalPrice.compareTo(BigDecimal.ZERO)==-1) {
				productPrice="0.00";
			}else {
				productPrice=totalPrice.toString();
			}
		}
		JSONObject jo = new JSONObject();
		jo.put("totalPrice", productPrice);
		return new RESTResponse("data", jo);
	}
}