package com.cku.restful.v1.dog.request;

import java.io.Serializable;

import org.hibernate.validator.constraints.NotBlank;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder(toBuilder = true)
@ApiModel("DNA管理采样包绑定实体")
public class RestDogDnaBindSamplingRequest implements Serializable {

	private static final long serialVersionUID = 428826159289813094L;

	@NotBlank(message = "DNA申请记录ID不能为空")
	@ApiModelProperty("DNA申请记录ID")
	private String id;

	@NotBlank(message = "采样包编号不能为空")
	@ApiModelProperty("采样包编号")
	private String samplingCode;

}
