package com.cku.oa.timedtask.service;

import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.sys.entity.MemberSyncTask;
import com.cku.oa.sys.service.MemberSyncTaskService;
import com.ufida.api.response.UfidaSyncResponse;
import com.ufida.api.service.UfidaBaseInfoSyncService;
import com.ufida.api.vo.CustomerVo;

@Service
@Transactional(readOnly = true)
public class UfidaCustomerSyncTask extends JobActingService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private MemberSyncTaskService memberSyncTaskService;

	@Autowired
	private UfidaBaseInfoSyncService ufidaBaseInfoSyncService;

	@Transactional(readOnly = false)
	int doJob() {
		int count = 0;
		try {
			MemberSyncTask memberSyncTask = new MemberSyncTask();
			memberSyncTask.setSyncStatus("0");
			List<MemberSyncTask> findList = memberSyncTaskService.findList(memberSyncTask);
			for (MemberSyncTask temp : findList) {
				UfidaSyncResponse syncProject = ufidaBaseInfoSyncService
						.syncCustomer(new CustomerVo(temp.getMemberCode(), temp.getMemberName(),
								temp.getMemberName() + "(" + temp.getMemberCode() + ")", null));
				if (syncProject.success()) {
					temp.setSyncTime(new Date());
					temp.setSyncStatus("1");
					memberSyncTaskService.save(temp);
				}
			}
			count = findList.size();
		} catch (Exception e) {
			count = -1;
		} finally {
			logger.info("修改数据,执行条数：" + count);
			return count;
		}
	}

	@Override
	@Transactional(readOnly = false)
	public int executeOnce() {
		int count = 0;
		try {
			SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
			count = this.doJob();
		} catch (Exception e) {
			count = -1;
		} finally {
			logger.info("修改数据,执行条数：" + count);
			return count;
		}
	}

}