package com.cku.oa.sys.service;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.dao.OrgChipDao;
import com.cku.oa.sys.entity.OrgChip;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 芯片发放记录Service
 * 
 * @author fanhuibin
 * @version 2016-09-06
 */
@Service
@Transactional(readOnly = true)
public class OrgChipService extends CrudService<OrgChipDao, OrgChip> {

	public OrgChip get(String id) {
		return super.get(id);
	}

	public List<OrgChip> findList(OrgChip orgChip) {
		return super.findList(orgChip);
	}

	public Page<OrgChip> findPage(Page<OrgChip> page, OrgChip orgChip) {
		return super.findPage(page, orgChip);
	}

	@Transactional(readOnly = false)
	public void save(OrgChip orgChip) {
		super.save(orgChip);
	}

	@Transactional(readOnly = false)
	public void delete(OrgChip orgChip) {
		super.delete(orgChip);
	}

	@Transactional(readOnly = false)
	public void batchSave(OrgChip orgChip, String[] cardNo) {
		if ("null".equals(cardNo[0])) {
			orgChip.setInvalid("0");
			orgChip.setChipCode(null);
			this.save(orgChip);
		} else {
			// 不可以重复限制
			List<OrgChip> list = dao.getByChipCodes(
					Arrays.asList(cardNo).stream().map(a -> orgChip.getChipPrefix() + a).collect(Collectors.toList()));
			if (list.size() > 0) {
				String msg = Arrays.toString(list.stream().map(a -> a.getChipCode()).collect(Collectors.toList())
						.stream().distinct().toArray());
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号" + msg + "已存在！");
			}
			for (int i = 0; i < cardNo.length; i++) {
				if (StringUtils.isNotBlank(cardNo[i])) {
					// 正常状态
					orgChip.setInvalid("0");
					orgChip.setId(null);
					orgChip.setChipCode(orgChip.getChipPrefix() + cardNo[i]);
					this.save(orgChip);
				}
			}
		}
	}

	/**
	 * 查询发放的记录
	 * 
	 * @return
	 */
	public List<OrgChip> getPutOutHistory(OrgChip chip) {
		return dao.getPutOutHistory(chip);
	}

	/**
	 * 分页查询发放记录
	 * 
	 * @Author chaixueteng
	 * @2016年10月9日下午5:56:46
	 */
	public Page<OrgChip> findChipPage(Page<OrgChip> page, OrgChip orgChip) {
		orgChip.setPage(page);
		page.setList(dao.getPutOutHistory(orgChip));
		return page;
	}

	/**
	 * 查询芯片是否在俱乐部备案中
	 * 
	 * @Author chaixueteng
	 * @2016年10月12日下午4:14:23
	 */
	public OrgChip getByOrgAndIdflag(String orgId, String identificationFlag) {
		return dao.getByOrgAndIdflag(orgId, identificationFlag);
	}

	/**
	 * 校验录入的芯片号不重复
	 * 
	 * @Author chaixueteng
	 * @2016年10月23日下午2:29:05
	 */
	public String checkChip(String chipCode, String id) {
		List<OrgChip> list = dao.getByChipCode(chipCode);
		if (list.size() > 0) {
			if (id != null) {
				String id2 = list.get(0).getId();
				if (!id.trim().equals(id2)) {
					return "{\"rc\":true}";
				} else {
					return "{\"rc\":false}";
				}
			} else {
				return "{\"rc\":true}";
			}
		}
		return "{\"rc\":false}";
	}

	/**
	 * 根据芯片号查询合作机构
	 * 
	 * @Author chaixueteng
	 * @2016年10月26日下午5:02:14
	 */
	public List<OrgChip> getByChip(String chip) {
		return dao.getByChipCode(chip);
	}

	/**
	 * 根据id和邮寄时间来删除批次数据
	 * 
	 * @param orgChip
	 * @Author chaixueteng
	 * @2017年06月02日下午5:02:14
	 */
	@Transactional(readOnly = false)
	public void deleteList(OrgChip orgChip) {
		orgChip.preUpdate();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		orgChip.setRemarks("[" + orgChip.getUpdateBy() + ":" + format.format(orgChip.getUpdateDate()) + "]");
		dao.deleteList(orgChip);
	}

}