/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.coupon.entity;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

import lombok.AllArgsConstructor;
import lombok.Builder;

/**
 * 优惠劵Entity
 * 
 * @author 柴雪腾
 * @version 2018-04-12
 */
@Builder
@AllArgsConstructor
public class SysCoupon extends DataEntity<SysCoupon> {

	private static final long serialVersionUID = 1L;
	
	@ExcelField(title = "会员号", align = 2, sort = 1)
	private String memberCode; // 会员号
	
	@ExcelField(title = "优惠券数量", align = 2, sort = 6)
	private Integer num;
	
	@ExcelField(title = "优惠券名称", align = 2, sort = 2)
	private String couponName; // 优惠劵名称
	
	@ExcelField(title = "优惠券面值", align = 2, sort = 3)
	private String facePrice; // 面值
	
	@ExcelField(title = "优惠券有效期", align = 2, sort = 4)
	private Date validDate; // 有效期
	@ExcelField(title = "优惠券生效日期", align = 2, sort = 5)
	private Date effectiveDate; // 生效日期
	
	private String explains; // 说明
	
	private String target; // 面向折扣对象
	private String targetId; // 主键
	private String state; // 状态
	private String runningNumber; // 订单号
	private String couponCode; // 优惠劵编码
	private String useState; // 是否使用
	
	private String couponType; // 优惠券类型 0普通，1代金券
	private String couponDefId;
	private String userCouponComposeId;
	private List<String> targetList;

	private String couponTypeAdmin;
	private String couponTypeApp;
	private String orderByStr;
	private String groupByStr;
	private String useStateDesc;
	
	private int couponNum;
	private String couponTypeDesc;
	private Boolean couponDelFlag;
	
	public List<String> getTargetList() {
		return targetList;
	}

	public void setTargetList(List<String> targetList) {
		this.targetList = targetList;
	}

	public String getCouponDefId() {
		return couponDefId;
	}

	public void setCouponDefId(String couponDefId) {
		this.couponDefId = couponDefId;
	}
	

	public Integer getNum() {
		return num;
	}

	public void setNum(Integer num) {
		this.num = num;
	}

	public SysCoupon() {
		super();
	}

	public SysCoupon(String id) {
		super(id);
	}

	@Length(min = 0, max = 100, message = "会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 100, message = "优惠劵名称长度必须介于 0 和 100 之间")
	public String getCouponName() {
		return couponName;
	}

	public void setCouponName(String couponName) {
		this.couponName = couponName;
	}

	@Length(min = 0, max = 11, message = "面值长度必须介于 0 和 11 之间")
	public String getFacePrice() {
		return facePrice;
	}

	public void setFacePrice(String facePrice) {
		this.facePrice = facePrice;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getValidDate() {
		return validDate;
	}

	public void setValidDate(Date validDate) {
		this.validDate = validDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	@Length(min = 0, max = 150, message = "说明长度必须介于 0 和 150 之间")
	public String getExplains() {
		return explains;
	}

	public void setExplains(String explains) {
		this.explains = explains;
	}

	@Length(min = 0, max = 100, message = "面向折扣对象长度必须介于 0 和 100 之间")
	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	public String getTargetId() {
		return targetId;
	}

	public void setTargetId(String targetId) {
		this.targetId = targetId;
	}

	public String getState() {
		return state;
	}
	

	public Boolean getCouponDelFlag() {
		return couponDelFlag;
	}

	public void setCouponDelFlag(Boolean couponDelFlag) {
		this.couponDelFlag = couponDelFlag;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	public String getCouponCode() {
		return couponCode;
	}

	public void setCouponCode(String couponCode) {
		this.couponCode = couponCode;
	}

	public String getUseState() {
		return useState;
	}

	public void setUseState(String useState) {
		this.useState = useState;
	}

	public String getCouponType() {
		return couponType;
	}

	public void setCouponType(String couponType) {
		this.couponType = couponType;
	}

	public String getUserCouponComposeId() {
		return userCouponComposeId;
	}

	public void setUserCouponComposeId(String userCouponComposeId) {
		this.userCouponComposeId = userCouponComposeId;
	}

	public String getCouponTypeAdmin() {
		return couponTypeAdmin;
	}

	public void setCouponTypeAdmin(String couponTypeAdmin) {
		this.couponTypeAdmin = couponTypeAdmin;
	}

	public String getCouponTypeApp() {
		return couponTypeApp;
	}

	public void setCouponTypeApp(String couponTypeApp) {
		this.couponTypeApp = couponTypeApp;
	}

	public String getOrderByStr() {
		return orderByStr;
	}

	public void setOrderByStr(String orderByStr) {
		this.orderByStr = orderByStr;
	}

	public String getGroupByStr() {
		return groupByStr;
	}

	public void setGroupByStr(String groupByStr) {
		this.groupByStr = groupByStr;
	}

	public int getCouponNum() {
		return couponNum;
	}

	public void setCouponNum(int couponNum) {
		this.couponNum = couponNum;
	}

	public String getCouponTypeDesc() {
		return couponTypeDesc;
	}

	public void setCouponTypeDesc(String couponTypeDesc) {
		this.couponTypeDesc = couponTypeDesc;
	}

	public String getUseStateDesc() {
		return useStateDesc;
	}

	public void setUseStateDesc(String useStateDesc) {
		this.useStateDesc = useStateDesc;
	}

	
	

}