package com.cku.oa.show.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.show.entity.ShowOffice;
import com.cku.oa.show.dao.ShowOfficeDao;

/**
 * 赛事办公室Service
 * @author 赖广龙
 * @version 2017-08-03
 */
@Service
@Transactional(readOnly = true)
public class ShowOfficeService extends CrudService<ShowOfficeDao, ShowOffice> {

	public ShowOffice get(String id) {
		return super.get(id);
	}
	
	public List<ShowOffice> findList(ShowOffice showOffice) {
		return super.findList(showOffice);
	}
	
	public Page<ShowOffice> findPage(Page<ShowOffice> page, ShowOffice showOffice) {
		return super.findPage(page, showOffice);
	}
	
	@Transactional(readOnly = false)
	public void save(ShowOffice showOffice) {
		super.save(showOffice);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowOffice showOffice) {
		super.delete(showOffice);
	}

	public List<ShowOffice> findAllList() {
		return dao.findAllList(new ShowOffice());
	}
	
}