/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.service;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.show.dao.ShowApplyDao;
import com.cku.oa.show.entity.CkuImage;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.service.FileService;
import com.cku.thirdparty.oss.OssApiClient;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 赛事子表Service
 * 
 * @author lgl
 * @version 2016-07-11
 */
@Service
@Transactional(readOnly = true)
public class MainShowsService extends CrudService<MainShowsDao, MainShows> {

	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;

	@Autowired
	private ShowApplyDao showApplyDao;

	public MainShows get(String id) {
		return super.get(id);
	}

	public List<MainShows> findAllMainShows() {
		return dao.findAllMainShows();
	}

	@Transactional(readOnly = false)
	public void save(MainShows mainShows) {
		super.save(mainShows);
	}

	/**
	 * 获取可以报名的主赛事
	 * 
	 * @return
	 */
	public List<MainShows> findUnCloseMainShows(String showLocation, String mainShowName, Date closingTime,
			Integer pageNo, Integer pageSize) {
		return dao.findUnCloseMainShows(showLocation, mainShowName, closingTime, pageNo, pageSize);
	}

	/**
	 * 
	 * @description: 定时任务执行方法，每天15点01分，把已过赛事报名时间的赛事标记为关闭报名状态
	 * @author: laiguanglong
	 * @date: 2016年10月31日 下午2:48:26
	 */
	@Transactional(readOnly = false)
	public int updateRegisterFlag() {
		return dao.updateRegisterFlag();
	}

	/**
	 * 删除图片
	 * 
	 * @Author chaixueteng
	 * @2017年8月28日上午10:34:43
	 */
	@Transactional(readOnly = false)
	public void deleteCkuImage(String mainShowId, String type) {
		if("imageMinUrl".equals(type)||"imageMaxUrl".equals(type)) {
			MainShows mainShows = dao.get(mainShowId);
			CkuImage ckuImage = dao.getCkuImage(mainShows.getShowLocation());
			if("imageMinUrl".equals(type)) {
				ckuImage.setImageMinUrl(null);
			}else {
				ckuImage.setImageMaxUrl(null);
			}
			dao.updateCkuImage(ckuImage);
		}else {
			MainShows mainShows = new MainShows();
			mainShows.setId(mainShowId);
			if ("handerImage".equals(type)) {
				mainShows.setHanderImage(type);
			} else if ("scheduleImage".equals(type)) {
				mainShows.setScheduleImage(type);
			} else {
				mainShows.setThumbnailImage(type);
			}
			mainShows.preUpdate();
			dao.deleteImage(mainShows);
		}
	}

	@Transactional(readOnly = false)
	public int showEndReceive(){
		// 查询今日结束的比赛
		List<MainShows> shows = dao.findAllEndShow();
		int count = 0;
		for (MainShows show : shows) {
			ShowApply showApply = new ShowApply();
			showApply.setMainShowId(show.getId());
			List<ShowApply> applys = showApplyDao.findList(showApply);
			for (ShowApply apply : applys) {
				if(StringUtils.isNotEmpty(apply.getRunningNumber())) {
					if(saPaymentDetailTotalService.financeConfirmTime(apply.getRunningNumber()) > 0) {
						count ++;
					}
				}
				if(StringUtils.isNotEmpty(apply.getPhoneApplyRunningNumber())) {
					if(saPaymentDetailTotalService.financeConfirmTime(apply.getPhoneApplyRunningNumber()) > 0) {
						count ++;
					}
				}
			}
		}
		if(!CollectionUtils.isEmpty(shows)) {
			dao.updateShowStatus(shows);
		}
		return count;
	}
	
	public CkuImage getCkuImageByRemarks(String remarks) {
		return dao.getCkuImage(remarks);
	}
	
	@Autowired
	private OssApiClient ossApiClient;
	
	@Autowired
	private FileService fileService;
	
	
	private String getOssUrl(String fileId) {
		BaseFile bfile = fileService.get(fileId);
		return ossApiClient.getOssUrl(bfile.getLocation(),bfile.getName());
	}
	
	@Transactional(readOnly = false)
	public void saveCkuImage(MainShows mainShows) {
		if(StringUtils.isNotBlank(mainShows.getImageMaxUrl())||StringUtils.isNotBlank(mainShows.getImageMinUrl())){
			String imageMinUrl = StringUtils.isNotBlank(mainShows.getImageMinUrlId())?getOssUrl(mainShows.getImageMinUrlId()):mainShows.getImageMinUrl();
			String imageMaxUrl = StringUtils.isNotBlank(mainShows.getImageMaxUrlId())?getOssUrl(mainShows.getImageMaxUrlId()): mainShows.getImageMaxUrl();
			CkuImage ckuImage = dao.getCkuImage(mainShows.getShowLocation());
			if(Objects.isNull(ckuImage)) {
				ckuImage = new CkuImage();
				ckuImage.setImageMinUrl(imageMinUrl);
				ckuImage.setImageMaxUrl(imageMaxUrl);
				ckuImage.setRemarks(mainShows.getShowLocation());
				ckuImage.preInsert();
				dao.insertCkuImage(ckuImage);
			}else {
				ckuImage.setImageMinUrl(imageMinUrl);
				ckuImage.setImageMaxUrl(imageMaxUrl);
				dao.updateCkuImage(ckuImage);
			}
		}
	}

}