package com.cku.oa.handler.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.handler.entity.ShowHandler;
import com.cku.oa.handler.service.ShowHandlerService;

/**
 * 积分榜牵犬师Controller
 * 
 * @author xx
 * @version 2022-06-08
 */
@Controller
@RequestMapping(value = "${adminPath}/handler/showHandler")
public class ShowHandlerController extends BaseController {

	@Autowired
	private ShowHandlerService showHandlerService;

	@ModelAttribute
	public ShowHandler get(@RequestParam(required = false) String id) {
		ShowHandler entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = showHandlerService.get(id);
		}
		if (entity == null) {
			entity = new ShowHandler();
		}
		return entity;
	}

	@RequiresPermissions("handler:showHandler:view")
	@RequestMapping(value = { "list", "" })
	public String list(ShowHandler showHandler, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowHandler> page = showHandlerService.findPage(new Page<ShowHandler>(request, response), showHandler);
		model.addAttribute("page", page);
		return "oa/handler/showHandlerList";
	}

	@RequiresPermissions("handler:showHandler:view")
	@RequestMapping(value = "form")
	public String form(ShowHandler showHandler, Model model) {
		model.addAttribute("showHandler", showHandler);
		return "oa/handler/showHandlerForm";
	}

	@RequiresPermissions("handler:showHandler:edit")
	@RequestMapping(value = "save")
	public String save(ShowHandler showHandler, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, showHandler)) {
			return form(showHandler, model);
		}
		ShowHandler sh = showHandlerService.getByMemberCode(showHandler.getMemberCode());
		if (sh != null) {
			if (!sh.getId().equals(showHandler.getId())) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "已有该会员信息，请查询修改！");
			}
		}
		showHandlerService.save(showHandler);
		addMessage(redirectAttributes, "保存积分榜牵犬师成功");
		return "redirect:" + Global.getAdminPath() + "/handler/showHandler/?repage";
	}

	@RequiresPermissions("handler:showHandler:edit")
	@RequestMapping(value = "delete")
	public String delete(ShowHandler showHandler, RedirectAttributes redirectAttributes) {
		showHandlerService.delete(showHandler);
		addMessage(redirectAttributes, "删除积分榜牵犬师成功");
		return "redirect:" + Global.getAdminPath() + "/handler/showHandler/?repage";
	}

}