package com.cku.oa.groomer.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.groomer.entity.GroomerExamQuestionsOptions;
import com.cku.oa.groomer.service.GroomerExamQuestionsOptionsService;

/**
 * 美容考试题选项表Controller
 * @author hjx
 * @version 2023-11-23
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerExamQuestionsOptions")
public class GroomerExamQuestionsOptionsController extends BaseController {

	@Autowired
	private GroomerExamQuestionsOptionsService groomerExamQuestionsOptionsService;
	
	@ModelAttribute
	public GroomerExamQuestionsOptions get(@RequestParam(required=false) String id) {
		GroomerExamQuestionsOptions entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerExamQuestionsOptionsService.get(id);
		}
		if (entity == null){
			entity = new GroomerExamQuestionsOptions();
		}
		return entity;
	}
	
	@RequiresPermissions("groomer:groomerExamQuestionsOptions:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerExamQuestionsOptions groomerExamQuestionsOptions, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerExamQuestionsOptions> page = groomerExamQuestionsOptionsService.findPage(new Page<GroomerExamQuestionsOptions>(request, response), groomerExamQuestionsOptions); 
		model.addAttribute("page", page);
		return "oa/groomer/groomerExamQuestionsOptionsList";
	}

	@RequiresPermissions("groomer:groomerExamQuestionsOptions:view")
	@RequestMapping(value = "form")
	public String form(GroomerExamQuestionsOptions groomerExamQuestionsOptions, Model model) {
		model.addAttribute("groomerExamQuestionsOptions", groomerExamQuestionsOptions);
		return "oa/groomer/groomerExamQuestionsOptionsForm";
	}

	@RequiresPermissions("groomer:groomerExamQuestionsOptions:edit")
	@RequestMapping(value = "save")
	public String save(GroomerExamQuestionsOptions groomerExamQuestionsOptions, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerExamQuestionsOptions)){
			return form(groomerExamQuestionsOptions, model);
		}
		groomerExamQuestionsOptionsService.save(groomerExamQuestionsOptions);
		addMessage(redirectAttributes, "保存美容考试题选项表成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerExamQuestionsOptions/?repage";
	}
	
	@RequiresPermissions("groomer:groomerExamQuestionsOptions:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerExamQuestionsOptions groomerExamQuestionsOptions, RedirectAttributes redirectAttributes) {
		groomerExamQuestionsOptionsService.delete(groomerExamQuestionsOptions);
		addMessage(redirectAttributes, "删除美容考试题选项表成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerExamQuestionsOptions/?repage";
	}

}