package com.cku.oa.groomer.web;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.entity.Curriculum;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.service.CurriculumService;
import com.cku.oa.groomer.service.GroomerCourseService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/** 推荐课程
 *user zhangxiang
 *2020年9月9日
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/curriculum")
public class CurriculumController extends BaseController {

	@Autowired
	private CurriculumService curriculumService;

	@Autowired
	private GroomerCourseService groomerCourseService;
	@RequestMapping(value = {"list", ""})
	public String list(Model model,Curriculum curriculum,HttpServletRequest request, HttpServletResponse response){
		Page<Curriculum> page = curriculumService.findPage(new Page<Curriculum>(request, response), curriculum);
		model.addAttribute("page", page);
		return "oa/groomer/curriculumList";
	}

	//编辑页
	@RequestMapping(value = {"form", ""})
	public String form(Model model,Curriculum curriculum){
		if(null!=curriculum && null!=curriculum.getId()){
			curriculum = curriculumService.get(curriculum.getId());
		}
		//课程列表
		//List<GroomerCourse> list = groomerCourseService.findList(new GroomerCourse());
		model.addAttribute("curriculum",curriculum);
		//model.addAttribute("groomerCourseList",list);
		return "oa/groomer/curriculumAdd";
	}


	//编辑 添加
	@RequiresPermissions("groomer:curriculum:save")
	@RequestMapping(value = {"save", ""})
	public String save(Model model,Curriculum curriculum){
		//保存之前判断序号是否重复
		curriculumService.ISrepeat(curriculum);
		//判断跳转课程
		if(StringUtils.isNotBlank(curriculum.getCurriculumJump())){
			List<GroomerCourse> groomerCourse = curriculumService.getGroomerCourse(curriculum);
			if(groomerCourse.size()<1){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的课程编号不匹配，请重新输入");
			}
			//判断是否审核通过
			if(!"3".equals(groomerCourse.get(0).getStates())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "输入的课程编号未审核通过");
			}
			curriculum.setCurriculumJump(groomerCourse.get(0).getCode());
		}
		//保存
		curriculumService.save(curriculum);
		return "redirect:"+ Global.getAdminPath()+"/groomer/curriculum/list?repage";
	}

	//推荐/取消推荐
	@RequiresPermissions("groomer:curriculum:isRecommend")
	@RequestMapping(value = {"isRecommend", ""})
	public String isRecommend(Model model,Curriculum curriculum){

		Curriculum curriculum1 = curriculumService.get(curriculum.getId());
		curriculum1.setRecommend(curriculum.getRecommend());
		curriculumService.save(curriculum1);
		return "redirect:"+ Global.getAdminPath()+"/groomer/curriculum/list?repage";
	}


	@ResponseBody
	@RequestMapping(value = {"iSrepeat", ""})
	public Object iSrepeat(Curriculum curriculum, HttpServletRequest request, HttpServletResponse response)throws IOException {
		//查重
		HashMap<String,String> map = new HashMap<String,String>();
		try {
			curriculumService.ISrepeat(curriculum);
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
	//获取课程
	@ResponseBody
	@RequestMapping(value = {"getGroomerCourse", ""})
	public Object getGroomerCourse(Curriculum curriculum, HttpServletRequest request, HttpServletResponse response)throws IOException {
		//查重
		HashMap<String,String> map = new HashMap<String,String>();
		try {
			List<GroomerCourse> groomerCourse = curriculumService.getGroomerCourse(curriculum);
			if(groomerCourse.size()>0){
				map.put("rc", "0");
				map.put("msg","查询到正确的跳转课程");
			}else{
				map.put("rc", "1");
				map.put("msg", "输入的课程编号不匹配，请重新输入");
			}
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
}
