package com.cku.oa.gcWeb.entity;

import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容师人才库Entity
 * @author yuanshuai
 * @version 2023-01-30
 */
public class GCWebTalent extends DataEntity<GCWebTalent> {
	
	private static final long serialVersionUID = 1L;
	private String title;		// 标题
	private String image;		// 图片
	private String cv;		// 履历
	private String groomer;		// 美容经历
	private String referee;		// 执裁经历
	private String breed;		// 繁殖经历
	private Integer showFlag;		// 显示标记（0不显示1显示）
	private Integer sort;		// 排序
	
	public GCWebTalent() {
		super();
	}

	public GCWebTalent(String id){
		super(id);
	}

	@Length(min=1, max=64, message="标题长度必须介于 1 和 64 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	@Length(min=0, max=255, message="图片长度必须介于 0 和 255 之间")
	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}
	
	public String getCv() {
		return cv;
	}

	public void setCv(String cv) {
		this.cv = cv;
	}
	
	public String getGroomer() {
		return groomer;
	}

	public void setGroomer(String groomer) {
		this.groomer = groomer;
	}
	
	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}
	
	public String getBreed() {
		return breed;
	}

	public void setBreed(String breed) {
		this.breed = breed;
	}
	
	@NotNull(message="显示标记不能为空")
	public Integer getShowFlag() {
		return showFlag;
	}

	public void setShowFlag(Integer showFlag) {
		this.showFlag = showFlag;
	}
	
	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}
	
}