package com.cku.oa.dog.web;

import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.service.DogSemenService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 犬只精子Controller
 *
 * @author lgl
 * @version 2017-08-28
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogSemen")
public class DogSemenController extends BaseController {

    @Autowired
    private DogSemenService dogSemenService;

    private final static String REPAGE = "redirect:" + Global.getAdminPath() + "/dog/dogSemen/?repage";

    private final static String AUTHORITY_PRDFIX = "dog:dogSemen:";

    @ModelAttribute
    public DogSemen get(@RequestParam(required = false) String id) {
        DogSemen entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogSemenService.get(id);
        }
        if (entity == null) {
            entity = new DogSemen();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(DogSemen dogSemen, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogSemen> page = dogSemenService.findPage(new Page<DogSemen>(request, response), dogSemen);
        model.addAttribute("page", page);
        return "oa/dog/dogsemen/dogSemenList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "form")
    public String form(DogSemen dogSemen, Model model) {
        model.addAttribute("dogSemen", dogSemen);
        return "oa/dog/dogsemen/dogSemenForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "save")
    public String save(DogSemen dogSemen, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, dogSemen)) {
            return form(dogSemen, model);
        }
        dogSemenService.save(dogSemen);
        addMessage(redirectAttributes, "保存犬只精子成功");
        return REPAGE;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "edit")
    @RequestMapping(value = "delete")
    public String delete(DogSemen dogSemen, RedirectAttributes redirectAttributes) {
        dogSemenService.delete(dogSemen);
        addMessage(redirectAttributes, "删除犬只精子成功");
        return REPAGE;
    }

}