package com.cku.oa.dog.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.dog.entity.DogPedigreeCertifiedExport;
import com.cku.oa.dog.service.DogPedigreeCertifiedExportService;
import com.cku.oa.dog.util.VodUtil;
import com.cku.oa.dog.vo.DogPedigreeCertifiedExportVO;
import com.cku.oa.finance.service.PaymentOrderService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 出口证书申请Controller
 * 
 * @author lgl
 * @version 2016-08-19
 */
@Controller
@RequestMapping(value = "${adminPath}/dogexport/dogPedigreeCertifiedExport")
public class DogPedigreeCertifiedExportController extends BaseController {

	@Autowired
	private DogPedigreeCertifiedExportService dogPedigreeCertifiedExportService;

	private final static String REPAGE = "redirect:" + Global.getAdminPath()
			+ "/dogexport/dogPedigreeCertifiedExport/?repage";

	private final static String AUTHORITY_PRDFIX = "dogexport:dogPedigreeCertifiedExport:";

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required = true) String runningNumber,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode,
			Model model) {
		model.addAttribute("dogPedigreeCertifiedExport",
				new DogPedigreeCertifiedExport(runningNumber, chargingItemId, memberCode));
		return "oa/dog/dogexport/dogPedigreeCertifiedExportOrderAdd";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "getDogByPedigreeCertified")
	@ResponseBody
	public Object getDogByPedigreeCertified(@RequestParam(required = true) String pedigreeCertified) {
		HashMap<String, String> map = dogPedigreeCertifiedExportService.getDogByPedigreeCertified(pedigreeCertified);
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "add")
	@ResponseBody
	public Object add(DogPedigreeCertifiedExport dogPedigreeCertifiedExport) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogPedigreeCertifiedExportService.add(dogPedigreeCertifiedExport);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, Model model) {
		List<DogPedigreeCertifiedExport> list = dogPedigreeCertifiedExportService.findList(dogPedigreeCertifiedExport);
		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogPedigreeCertifiedExportVO> list2 = list.stream().map(a -> {
			DogPedigreeCertifiedExportVO b = new DogPedigreeCertifiedExportVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);

		return "oa/dog/dogexport/dogPedigreeCertifiedExportOrderList";
	}

	@ModelAttribute
	public DogPedigreeCertifiedExport get(@RequestParam(required = false) String id) {
		DogPedigreeCertifiedExport entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogPedigreeCertifiedExportService.get(id);
		}
		if (entity == null) {
			entity = new DogPedigreeCertifiedExport();
			return entity; 
		}
		
		if (StringUtils.isNotEmpty(entity.getVodUrl())) {
			entity.setOldVodurl(entity.getVodUrl());
			String vodUrl = VodUtil.getVodUrl("certificateExport", entity.getVodUrl());
			entity.setVodUrl(vodUrl);
		}
		return entity;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = { "list", "" })
	public String list(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<DogPedigreeCertifiedExport> page = dogPedigreeCertifiedExportService
				.findPage(new Page<DogPedigreeCertifiedExport>(request, response), dogPedigreeCertifiedExport);

		// 查询有没有退款或退款中 fmdog_breed_certified_code
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogPedigreeCertifiedExport> list = page.getList().stream().map(a -> {
			DogPedigreeCertifiedExportVO b = new DogPedigreeCertifiedExportVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		if ("230".equals(dogPedigreeCertifiedExport.getDogBreed())) {
			return "oa/dog/dogexport/dogPedigreeCertifiedExportListZangao";
		}
		return "oa/dog/dogexport/dogPedigreeCertifiedExportList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "form")
	public String form(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, Model model) {

		model.addAttribute("dogPedigreeCertifiedExport", dogPedigreeCertifiedExport);
		return "oa/dog/dogexport/dogPedigreeCertifiedExportForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, Model model) {
		model.addAttribute("dogPedigreeCertifiedExport", dogPedigreeCertifiedExport);
		return "oa/dog/dogexport/dogPedigreeCertifiedExportEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "edit")
	public String edit(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, Model model,
			RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogPedigreeCertifiedExport)) {
			return editForm(dogPedigreeCertifiedExport, model);
		}
		if(StringUtils.isNotEmpty(dogPedigreeCertifiedExport.getOldVodurl())) {
			dogPedigreeCertifiedExport.setVodUrl(dogPedigreeCertifiedExport.getOldVodurl());
		}
		dogPedigreeCertifiedExportService.save(dogPedigreeCertifiedExport);
		addMessage(redirectAttributes, "编辑证书出口成功");
		return repage(dogPedigreeCertifiedExport);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "save")
	public String save(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, Model model,
			RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogPedigreeCertifiedExport)) {
			return form(dogPedigreeCertifiedExport, model);
		}
		dogPedigreeCertifiedExportService.save(dogPedigreeCertifiedExport);
		addMessage(redirectAttributes, "保存出口证书申请成功");
		return repage(dogPedigreeCertifiedExport);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "delete")
	public String delete(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, RedirectAttributes redirectAttributes) {
		dogPedigreeCertifiedExportService.delete(dogPedigreeCertifiedExport);
		addMessage(redirectAttributes, "删除出口证书申请成功");
		return repage(dogPedigreeCertifiedExport);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "auditForm")
	public String auditForm(String id, Model model) {
		DogPedigreeCertifiedExport export = dogPedigreeCertifiedExportService.get(id);
		if(StringUtils.isNotEmpty(export.getVodUrl())) {
			export.setVodUrl(VodUtil.getVodUrl("certificateExport", export.getVodUrl()));
		}
		model.addAttribute("dogPedigreeCertifiedExport", export);
		return "oa/dog/dogexport/dogPedigreeCertifiedExportAuditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "audit")
	@ResponseBody
	public Object audit(DogPedigreeCertifiedExport dogPedigreeCertifiedExport) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogPedigreeCertifiedExportService.audit(dogPedigreeCertifiedExport);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resolve")
	@RequestMapping(value = "resolve")
	public String resolve(DogPedigreeCertifiedExport dogPedigreeCertifiedExport,
			RedirectAttributes redirectAttributes) {
		addMessage(redirectAttributes, "处理证书出口成功");
		try {
			dogPedigreeCertifiedExportService.resolve(dogPedigreeCertifiedExport);
		} catch (Exception e) {
			addMessage(redirectAttributes, "处理证书出口失败:" + e.getMessage());
		}
		return repage(dogPedigreeCertifiedExport);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "print")
	@RequestMapping(value = "print")
	public String print(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, Model model) {
		return dogPedigreeCertifiedExportService.print(dogPedigreeCertifiedExport, model);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(DogPedigreeCertifiedExport dogPedigreeCertifiedExport,
			RedirectAttributes redirectAttributes) {
		dogPedigreeCertifiedExportService.resetPrint(dogPedigreeCertifiedExport);
		addMessage(redirectAttributes, "重置证书出口打印成功");
		return repage(dogPedigreeCertifiedExport);
	}

	/**
	 * 
	 * @description: 根据犬种判断是否跳藏獒的列表页
	 * @author: laiguanglong
	 * @date: 2016年9月3日 下午3:48:33
	 */
	private String repage(DogPedigreeCertifiedExport dogPedigreeCertifiedExport) {
		if ("230".equals(dogPedigreeCertifiedExport.getDogBreed())) {
			return REPAGE + "&dogBreed=230";
		}
		return REPAGE;
	}
}