package com.cku.oa.dog.service;

import java.util.List;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.dog.entity.DogChipMemberLock;
import com.cku.oa.dog.dao.DogChipMemberLockDao;

/**
 * 犬只芯片会员锁定Service
 *
 * @author yuanshuai
 * @version 2021-03-02
 */
@Service
@Transactional(readOnly = true)
public class DogChipMemberLockService extends CrudService<DogChipMemberLockDao, DogChipMemberLock> {

	@Autowired
	private MemberService memberService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private LoginServerService loginServerService;

	public DogChipMemberLock get(String id) {
		return super.get(id);
	}

	public List<DogChipMemberLock> findList(DogChipMemberLock dogChipMemberLock) {
		return super.findList(dogChipMemberLock);
	}

	public Page<DogChipMemberLock> findPage(Page<DogChipMemberLock> page, DogChipMemberLock dogChipMemberLock) {
		Page<DogChipMemberLock> resultPage = super.findPage(page, dogChipMemberLock);
		//查询犬种
		for (DogChipMemberLock lock : resultPage.getList()) {
			String dogBreed;
			Dog dog = dogService.getByIdentificationFlag(lock.getIdentificationFlag());
			if (dog == null || StringUtils.isBlank(dog.getId())) {
				DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByIdentificationFlag(lock.getIdentificationFlag());
				if (dogBirthCertificate == null || StringUtils.isBlank(dogBirthCertificate.getId())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "该芯片号有误，请核对");
				} else {
					dogBreed = dogBirthCertificate.getDogBreed();
				}
			} else {
				dogBreed = dog.getDogBreed();
			}
			DogType dogType = dogTypeService.getByDogBreedCode(dogBreed);
			lock.setDogBreed(dogType.getBreedCnName());
		}
		return resultPage;
	}

	@Transactional(readOnly = false)
	public void save(DogChipMemberLock dogChipMemberLock) {
		super.save(dogChipMemberLock);
	}

	@Transactional(readOnly = false)
	public void delete(DogChipMemberLock dogChipMemberLock) {
		super.delete(dogChipMemberLock);
	}

	/**
	 * 保存锁定信息
	 *
	 * @author yuanshuai
	 * @date 2021/3/2 14:08
	 */
	@Transactional(readOnly = false)
	public void saveData(DogChipMemberLock dogChipMemberLock) {
		//校验会员号是否存在
		Member member = memberService.getByMemberCode(dogChipMemberLock.getMemberCode());
		if (member == null || StringUtils.isBlank(member.getId())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该会员号有误，请核对");
		}

		//校验芯片号是否存在
		String dogBreed;
		Dog dog = dogService.getByIdentificationFlag(dogChipMemberLock.getIdentificationFlag());
		if (dog == null || StringUtils.isBlank(dog.getId())) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByIdentificationFlag(dogChipMemberLock.getIdentificationFlag());
			if (dogBirthCertificate == null || StringUtils.isBlank(dogBirthCertificate.getId())) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "该芯片号有误，请核对");
			} else {
				dogBreed = dogBirthCertificate.getDogBreed();
			}
		} else {
			dogBreed = dog.getDogBreed();
		}
		//新增时校验是否重复
		if (StringUtils.isBlank(dogChipMemberLock.getId())) {
			checkExistLockData(dogChipMemberLock);
		}
		//校验是否有已经存在锁定
		DogChipMemberLock lock = getByChipCode(dogChipMemberLock.getIdentificationFlag(), "1");
		if (lock != null && !StringUtils.isBlank(lock.getId()) && !lock.getId().equals(dogChipMemberLock.getId())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该芯片已有锁定信息，请核对");
		}
		//校验会员站点
		loginServerService.findDogTypeByMemberSite(dogBreed, member.getMemberSite());
		//保存
		save(dogChipMemberLock);
	}

	/**
	 * 校验犬只是否已锁定
	 *
	 * @author yuanshuai
	 * @date 2021/3/2 16:32
	 */
	public void checkDogLocked(String memberCode, String identificationFlag) {
		DogChipMemberLock dogChipMemberLock = getByChipCode(identificationFlag, "1");
		if (dogChipMemberLock != null && !StringUtils.isBlank(dogChipMemberLock.getId())) {
			if (!memberCode.equals(dogChipMemberLock.getMemberCode())
					&& "1".equals(dogChipMemberLock.getLockState())) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "此犬只未已锁定犬只，新犬主只能为" + dogChipMemberLock.getMemberCode());
			}
		}
	}

	/**
	 * 确认是否已经存在锁定数据
	 *
	 * @author yuanshuai
	 * @date 2021/3/2 14:29
	 */
	private void checkExistLockData(DogChipMemberLock dogChipMemberLock) {
		int count = dao.checkExistLockData(dogChipMemberLock);
		if (count > 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该犬只及会员关系已经存在，请核对");
		}
	}

	/**
	 * 根据芯片号查询锁定信息
	 *
	 * @author yuanshuai
	 * @date 2021/3/2 15:58
	 */
	public DogChipMemberLock getByChipCode(String identificationFlag, String lockState) {
		return dao.getByChipCode(identificationFlag, lockState);
	}

	/**
	 * 根据会员号查询锁定信息
	 *
	 * @author yuanshuai
	 * @date 2021/3/2 16:27
	 */
	public DogChipMemberLock getByMemberCode(String memberCode) {
		return dao.getByMemberCode(memberCode);
	}
}