package com.cku.oa.contest.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.contest.entity.ContestGrade;
import com.cku.oa.contest.dao.ContestGradeDao;

/**
 * 赛场评价Service
 * @author yuanshuai
 * @version 2020-10-12
 */
@Service
@Transactional(readOnly = true)
public class ContestGradeService extends CrudService<ContestGradeDao, ContestGrade> {

	public ContestGrade get(String id) {
		return super.get(id);
	}
	
	public List<ContestGrade> findList(ContestGrade contestGrade) {
		return super.findList(contestGrade);
	}
	
	public Page<ContestGrade> findPage(Page<ContestGrade> page, ContestGrade contestGrade) {
		return super.findPage(page, contestGrade);
	}
	
	@Transactional(readOnly = false)
	public void save(ContestGrade contestGrade) {
		super.save(contestGrade);
	}
	
	@Transactional(readOnly = false)
	public void delete(ContestGrade contestGrade) {
		super.delete(contestGrade);
	}

	/**
	 * @Description 根据编号和年龄组别获得成绩
	 * @author yuanshuai
	 * @date 2020/11/13 16:15
	 */
	public ContestGrade getByCodeAndAgeGroup(String grade, String classNo) {
		return dao.getByCodeAndAgeGroup(grade,classNo);
	}
}