define(["knockout"], function(ko) {
  return function(context) {
    var me = this;
    me.member = ko.observable(userInfo.getMember());
    me.user = ko.observable(userInfo.getUser());
    //省List
    me.provinceList = ko.observableArray([]);
    //市List
    me.cityList = ko.observableArray([]);
    me.areaList = ko.observableArray([]);

    me.selectedProvince = ko.observableArray("");
    //市List
    me.selectedCity = ko.observableArray("");
    me.selectedArea = ko.observableArray("");

    me.provinceHtml = ko.observable("");
    me.cityHtml = ko.observable("");
    me.areaHtml = ko.observable("");

    //绑定安全手机的显隐
    me.isbd = ko.observable(true); //默认不显示
    me.content = ko.observable("");
    me.yesBind = ko.observable("");
    me.noBind = ko.observable("");

    //初始化修改框为隐藏
    me.updateFlag = ko.observable(false);
    if (
      me.member().memberType == "basic" ||
      me.member().memberType == "基础会员"
    ) {
      me.member().memberType = "基础会员";
    } else if (
      me.member().memberType == "professional" ||
      me.member().memberType == "专业会员"
    ) {
      if (me.member().registerFlag == "1") {
        me.member().memberType = "繁育专业会员";
      } else {
        me.member().memberType = "专业会员";
      }
    } else {
      me.member().memberType = "外籍会员";
    }

    //修改用户信息model
    me.updateMember = ko.observable({
      name: "",
      gender: "",
      nameEn: "",
      cardNo: "",
      phone: "",
      mobile: "",
      birthday: "",
      fax: "",
      qq: "",
      email: "",
      nickName: "",
      province: "",
      city: "",
      street: "",
      postcode: "",
      avatar: "",
      deliveryNotice: "",
      deliveryCertified: ""
    });
    //会员续费
    me.memberRenew = function() {
      if (util.isVal(me.member().safeMobile) == "") {
        me.content(
          "尊敬的会员您好，由于CKU会员中心系统账户安全升级，安全监测发现您会员账户尚未进行实名认证且未绑定安全手机，当前业务无法正常办理。请先完成安全手机绑定。"
        );
        me.yesBind("去绑定安全手机号");
        me.noBind("暂不绑定，继续办理其他业务");
        me.isbd(false);
      } else {
        if (
          me.member().memberType == "专业会员" ||
          me.member().memberType == "繁育专业会员"
        ) {
          location.href = location.href.split("#")[0] + "#/order/renew";
        } else {
          util.sendAjax({
            url: "member/renew",
            data: {},
            async: false,
            type: "POST",
            cache: false,
            success: function(json) {
              if (json.rc == 0) {
                context.app.changeCart();
                layer.alert("业务添加成功，是否跳转到业务核对页面进行支付？", {
                  time: 0, //不自动关闭
                  btn: ["跳转", "取消"],
                  yes: function(index) {
                    layer.close(index);
                    location.href =
                      location.href.split("#")[0] + "#/order/check";
                  }
                });
              } else {
                layer.msg(
                  "会员续费失败,错误代码:" + json.rc + "错误信息:" + json.msg
                );
              }
            }
          });
        }
      }
    };

    //会员升级
    me.memberUpgrade = function() {
      if (util.isVal(me.member().safeMobile) == "") {
        me.content(
          "尊敬的会员您好，由于CKU会员中心系统账户安全升级，安全监测发现您会员账户尚未进行实名认证且未绑定安全手机，当前业务无法正常办理。请先完成安全手机绑定。"
        );
        me.yesBind("去绑定安全手机号");
        me.noBind("暂不绑定，继续办理其他业务");
        me.isbd(false);
      } else {
        location.href = location.href.split("#")[0] + "#/order/renew";
        // util.sendAjax({
        //   url: "member/upgrade",
        //   data: {},
        //   async: false,
        //   type: "POST",
        //   cache: false,
        //   success: function(json) {
        //     if (json.rc == 0) {
        //       context.app.changeCart();
        //       layer.alert("业务添加成功，是否跳转到业务核对页面进行支付？", {
        //         time: 0, //不自动关闭
        //         btn: ["跳转", "取消"],
        //         yes: function(index) {
        //           layer.close(index);
        //           location.href = location.href.split("#")[0] + "#/order/check";
        //         }
        //       });
        //     } else {
        //       layer.msg(
        //         "会员升级失败,错误代码:" + json.rc + "错误信息:" + json.msg
        //       );
        //     }
        //   }
        // });
      }
    };

    //安全手机换绑
    me.changeBind = function() {
      if (util.isVal(me.member().safeMobile) == "") {
        me.content("您还未绑定安全手机");
        me.yesBind("去绑定安全手机号");
        me.noBind("暂不绑定，继续办理其他业务");
        me.isbd(false);
      } else {
        window.location.href = "#/accountsecurity/mobileChangeOld";
      }
    };

    //修改弹出框点击修改按钮
    me.updateClick = function() {
      if (me.updateFlag() == true) {
        me.updateFlag(false);
      } else {
        me.updateFlag(true);
      }
      if ($(".updateshowem").css("display") == "none") {
        $(".updateshowem").css("display", "block");
        $("#editFlag").css("display", "none");
      }
      // me.cityList.removeAll();
      // me.provinceList.removeAll();
      // me.initProCity(me.member().province, me.member().city);
      me.getProvince();
    };

    //选中省份
    me.changeProvince = function(data, event) {
      const provinceId = me.selectedProvince().provinceId;
      me.getCity(provinceId);
    };

    me.changeCity = function(data, event) {
      const cityId = me.selectedCity().cityId;
      me.getArea(cityId);
    };

    me.changeArea = function(data, event) {
    };

    me.initProCity = function(province, city) {
      me.cityList.removeAll();
      me.provinceList.removeAll();
      for (var i = 0; i < util.city.length; i++) {
        var obj = { name: util.city[i].local };
        me.provinceList.push(obj);
        if (province == util.city[i].local) {
          $("#province")
            .val(province)
            .trigger("change");
          for (var j = 0; j < util.city[i].localcity.length; j++) {
            var obj1 = { name: util.city[i].localcity[j] };
            me.cityList.push(obj1);
            if (city == util.city[i].localcity[j]) {
              $("#city")
                .val(city)
                .trigger("change");
            }
          }
        }
      }
    };

    //请求省列表
    me.getProvince = function() {
      var sendData = {};
      util.sendAjax(
        {
          url: "province/list.do",
          data: sendData,
          async: false,
          type: "GET",
          cache: false,
          success: function(json) {
            if (json.rc == 0 && json.items && json.items.length > 0) {
              me.provinceList(json.items);
              me.provinceHtml(json.items[0]);
              me.selectedProvince(json.items[0]);
              me.getCity(json.items[0].provinceId);
            } else {
              me.provinceList([]);
            }
          }
        },
        "/caibmobile/sys-api/"
      );
    };
    //请求市列表
    me.getCity = function(provinceId) {
      var sendData = {};
      sendData["province_code"] = provinceId;

      util.sendAjax(
        {
          url: "city/list.do",
          data: sendData,
          async: false,
          type: "GET",
          cache: false,
          success: function(json) {
            if (json.rc == 0 && json.items && json.items.length > 0) {
              me.cityList(json.items);
              me.cityHtml(json.items[0]);
              me.selectedCity(json.items[0]);
              me.getArea(json.items[0].cityId);
            } else {
              me.cityList([]);
            }
          }
        },
        "/caibmobile/sys-api/"
      );
    };
    //请求区列表
    me.getArea = function(cityId) {
      var sendData = {};
      sendData["city_code"] = cityId;
      util.sendAjax(
        {
          url: "area/list.do",
          data: sendData,
          async: false,
          type: "GET",
          cache: false,
          success: function(json) {
            if (json.rc == 0 && json.items && json.items.length > 0) {
              me.areaList(json.items);
              me.selectedArea(json.items[0]);
              me.areaHtml(json.items[0].area);
            } else {
              me.areaList([]);
            }
          }
        },
        "/caibmobile/sys-api/"
      );
    };
    /**
     * 修改会员信息
     */
    me.save = function() {
      //修改数据
      var val = $("#birthday").val();
      me.member().birthday = val;
      // me.member().province = $("#province").select2("val");
      // me.member().city = $("#city").select2("val");
      me.member().province = me.selectedProvince().province;
      me.member().city = me.selectedCity().city;
      me.member().area = me.selectedArea().area;
      me.member().avatar = $("#avatar").val();
      me.member().deliveryCertified = $(
        "#deliveryCertified option:selected"
      ).val();
      me.member().gender = $("#gender option:selected").val();
      if (!util.isEmail(me.member().email)) {
        layer.msg("邮箱格式不正确！");
        return;
      }
      //放宽手机的验证标准，
      //            if(!util.isMobile(me.member().mobile)){
      //                layer.msg("手机号码不正确！");
      //                return;
      //            }
      if (util.isVal(me.member().street.trim()) == "") {
        layer.msg("地址不可为空!");
        return;
      }
      me.updateMember().name = me.member().name;
      me.updateMember().gender = me.member().gender;
      me.updateMember().nameEn = me.member().nameEn;
      me.updateMember().cardNo = me.member().cardNo;
      me.updateMember().phone = me.member().phone;
      me.updateMember().mobile = me.member().mobile;
      me.updateMember().birthday = me.member().birthday;
      // me.updateMember().province = $("#province").select2("val");
      // me.updateMember().city = $("#city").select2("val");
      me.updateMember().province = me.selectedProvince().province;
      me.updateMember().city = me.selectedCity().city;
      me.updateMember().area = me.selectedArea().area;

      me.updateMember().street = me.member().street;
      me.updateMember().postcode = me.member().postcode;
      me.updateMember().fax = me.member().fax;
      me.updateMember().qq = me.member().qq;
      me.updateMember().email = me.member().email;
      me.updateMember().nickName = me.user().name;
      me.updateMember().avatar = me.member().avatar;
      me.updateMember().deliveryNotice = "到付快递";
      me.updateMember().deliveryCertified = me.member().deliveryCertified;
      var updateData = me.updateMember();
      /**
       * 修改个人信息
       */
      util.sendAjax({
        url: "userCenter/personalInfo",
        data: JSON.stringify(updateData),
        async: true,
        loadFlag: true,
        type: "PUT",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            layer.msg("修改个人信息成功！");
            window.location.reload();
          } else {
            layer.msg(
              "修改个人信息失败,错误代码:" + json.rc + "错误信息:" + json.msg
            );
          }
        }
      });
    };
    me.uploadImg = function() {
      layer.open({
        type: 2,
        title: "证件照上传",
        shadeClose: true,
        shade: 0.8,
        area: ["480px", "340px"],
        content: "/oa-web/api/v1/file/uploadPage"
      });
    };
    context.app.loading(false);
    context.app.isShop(false);

    //点击绑定手机号/暂不绑定退出事件
    this.changeTopNav = function(type) {
      if (type == "no") {
        //退出
        me.isbd(true);
      } else if (type == "bd") {
        //绑定
        window.location.href =
          "login.html#/accountsecurity/identityverification";
      }
    };
  };
});
