//丢失补做添加，变更补做添加，登录补做添加
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        userInfo.refresh();
        //会员信息
        me.member = ko.observable(userInfo.getMember());
        // 证书补做类型：变更补做为1，丢失补做2，登录补做3，index进来默认为2,
        me.changeType = ko.observable("2");
        //标题文本
        me.changeTypeText = ko.observable("证书丢失补做申请");
        //血统证书号
        me.pedigreeCertifiedCode = ko.observable("");
        //根据血统证书号查出来的狗信息
        me.mydog = ko.observable({});
        //获取价格
        me.showPrice = ko.observable("0");
        /**
         * 我的犬只列表根据血统证书号查询
         */
        me.getDog = function(){
            if(me.pedigreeCertifiedCode()==""){
                layer.msg("血统证书号不能为空！");
            }else{
                var sendData = {};
                sendData["pedigreeCertifiedCode"] = me.pedigreeCertifiedCode().trim();
                util.sendAjax({
                    url:'dog/dog',
                    data:sendData,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            if(json.list!=null && json.list.length>0){
                                me.mydog(json.list[0]);
                                var id = me.mydog().id;
                                me.pedigreeCertifiedCode(json.list[0].pedigreeCertifiedCode);
                                me.getPrice(id);
                            }else{
                                layer.msg("该犬只不在您名下，无法申请此业务!");
                                me.mydog({});
                                me.showPrice("0");
                            }
                        }else{
                            layer.msg("信息查询失败："+json.msg);
                        }

                    }
                });
            }
        }
        //获取价格
        me.getPrice = function(id){
            var sendData = {};
            sendData["dogId"] = id;
            util.sendAjax({
                url:'dog/dogpedigreecertifiedredo/getPrice',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.showPrice(json.data.price);
                    }else{
                        layer.msg("获取价格失败:"+json.msg);
                    }

                }
            });
        }
        /**
         * 保存
         */
        me.saveCart = function(){
            /*var endTime = new Date(new Date(util.formatDateShort(me.member().memberEndDate).replace(/-/g,"/"))).getTime()+86399000-new Date().getTime();
            if(endTime>=0){*/
                var sendData = {};
                sendData["dogId"] = me.mydog().id;
                sendData["changeType"] = me.changeType();
                sendData["stickerFlag"] = me.applyChecked() ? 1:0;
                util.sendAjax({
                    url:'dog/dogpedigreecertifiedredo',
                    data:JSON.stringify(sendData),
                    async:true,
                    loadFlag:true,
                    type:'POST',
                    cache:false,
                    success:function(json){
                        if(json.rc ==0){
                            context.app.changeCart();
                            layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                                time: 0 //不自动关闭
                                ,btn: ['跳转', '取消']
                                ,yes: function(index){
                                    layer.close(index);
                                    location.href = location.href.split("#")[0]+"#/order/check";
                                }
                            });
                        }else{
                            layer.msg("补做申请失败:"+json.msg);
                        }
                    }
                });
            /*}else{
                layer.msg("只有有效会员有权限提交申请！");
            }*/
        }

        /*宠爱护照及等级贴纸申请*/
        me.applyChecked = ko.observable(false);
        /*宠爱护照及等级贴纸申请*/
        me.toggleSelect = function(){
            me.applyChecked(!me.applyChecked());
        }

        //初始化方法
        $(function(){
            var obj = util.getQueryString();
            if(!util.isVal(obj.changeType)==""){
                me.changeType(obj.changeType);
                if(obj.changeType=="1"){
                    me.changeTypeText("证书变更补做申请");
                }else if(obj.changeType=="2"){
                    me.changeTypeText("证书丢失补做申请");
                }else if(obj.changeType=="3"){
                    me.changeTypeText("证书登录补做申请");
                }
            }
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});