<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只精子变更管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }

    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctxDc}/dogSemenChange">犬只精子变更列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="dogSemenChange" action="${ctxDc}/dogSemenChange" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>血统证书/芯片号：</label>
            <form:input path="pedigreeCertifiedAndDogChipLike" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>原精子所有人姓名/会员号：</label>
            <form:input path="originMemberCodeAndOriginMemberNameLike" htmlEscape="false" maxlength="64"
                        class="input-medium"/>
        </li>
        <li><label>新精子所有人姓名/会员号：</label>
            <form:input path="newMemberCodeAndNewMemberNameLike" htmlEscape="false" maxlength="64"
                        class="input-medium"/>
        </li>
        <li><label>CKU精子编号：</label>
            <form:input path="semenCodeLike" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>原犬主审核状态：</label>
            <form:select path="reviewState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:option value="0" label="未审核"/>
                <form:option value="1" label="原主人通过"/>
                <form:option value="2" label="原主人未通过"/>
            </form:select>
        </li>
        <li><label>协会审核状态：</label>
            <form:select path="ckuReviewState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:option value="0" label="未审核"/>
                <form:option value="1" label="协会通过"/>
                <form:option value="2" label="协会未通过"/>
            </form:select>
        </li>
        <li><label>申请日期：</label>
            <input name="createDateStart" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${dogSemenChange.createDateStart}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
            <input name="createDateEnd" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${dogSemenChange.createDateEnd}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>血统证书号</th>
        <th>芯片号</th>
        <th>犬种</th>
        <th>犬名</th>
        <th>CKU精子编号</th>
        <th>原精子主人</th>
        <th>新精子主人</th>
        <th>付款状态</th>
        <th>原主人审核状态</th>
        <th>协会审核状态</th>
        <th>处理状态</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="dogSemenChange">
        <tr>
            <td>
                    ${fns:escapeHtml(dogSemenChange.pedigreeCertified)}
            </td>
            <td>
                    ${fns:escapeHtml(dogSemenChange.dogChip)}
            </td>
            <td>
                    ${fns:escapeHtml(dogSemenChange.dogBreed)}
            </td>
            <td>
                    ${fns:escapeHtml(dogSemenChange.dogName)}
            </td>
            <td>
                    ${fns:escapeHtml(dogSemenChange.semenCode)}
            </td>
            <td>
                    ${fns:escapeHtml(dogSemenChange.originMemberCode)}(${fns:escapeHtml(dogSemenChange.originMemberName)})
            </td>
            <td>
                    ${fns:escapeHtml(dogSemenChange.newMemberCode)}(${fns:escapeHtml(dogSemenChange.newMemberName)})
            </td>
            <td>
                    ${fns:getDictLabel(dogSemenChange.paymentState, 'user_payment_state', '')}
            </td>
            <td>
                    ${fns:getDictLabel(dogSemenChange.reviewState, 'review_state', '')}
            </td>
            <td>
                    ${fns:getDictLabel(dogSemenChange.ckuReviewState, 'review_state', '')}
            </td>
            <td>
                                ${fns:getDictLabel(dogSemenChange.processState, 'proccess_state', '')}
            </td>
            <td>
                    <a href="${ctxDc}/dogSemenChange/form?id=${fns:escapeHtml(dogSemenChange.id)}">查看</a>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>