<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>配种证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
            $(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/dogNewborn">配种证明列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogNewborn" action="${ctxDc}/dogNewborn" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>配种证明编号：</label>
				<form:input path="breedCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>所属地区：</label>
				<form:input path="area" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>公犬主名/会员号：</label>
				<form:input path="maleDogOwner" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>母犬主名/会员号：</label>
				<form:input path="femaleDogOwner" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>公犬证书号：</label>
				<form:input path="malePedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>母犬证书号：</label>
				<form:input path="femalePedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>配种日期：</label>
				<input name="breedDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogNewborn.breedDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>出生日期：</label>
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogNewborn.birthday}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>精子编号：</label>
				<form:input path="semenCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>加急：</label>
				<form:select path="urgent" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
                <form:select path="reviewState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>缴费状态：</label>
                <form:select path="paymentState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>配种证明编号</th>
				<th>所属地区</th>
				<th>公犬主</th>
				<th>公犬证书号</th>
				<th>母犬主</th>
				<th>母犬证书号</th>
				<th>配种日期</th>
				<th>出生日期</th>
				<th>精子编号</th>
				<th>加急</th>
				<th>近亲</th>
				<th>支付状态</th>
				<th>审核状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogNewborn">
			<tr>
				<td>
				    ${fns:escapeHtml(dogNewborn.breedCertifiedCode) }
				</td>
				<td>
					${fns:escapeHtml(dogNewborn.area) }
				</td>
				<td title="${dogNewborn.mdogOwnerCode }">
					${fns:escapeHtml(dogNewborn.maleDogOwner) }
				</td>
				<td>
                    ${fns:escapeHtml(dogNewborn.malePedigreeCertified) }
                </td>
				<td title="${dogNewborn.fdogOwnerCode }">
					${fns:escapeHtml(dogNewborn.femaleDogOwner) }
				</td>
				<td>
					${fns:escapeHtml(dogNewborn.femalePedigreeCertified) }
				</td>
				<td>
					<fmt:formatDate value="${dogNewborn.breedDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogNewborn.birthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
						${fns:escapeHtml(dogNewborn.semenCode) }
				</td>
				<td>
				    <c:if test="${dogNewborn.urgent==0}">${fns:getDictLabel(dogNewborn.urgent, 'yes_no', '')}</c:if>
				    <c:if test="${dogNewborn.urgent==1}"><font color="red">${fns:getDictLabel(dogNewborn.urgent, 'yes_no', '')}</font></c:if>
				</td>
				<td>
						<c:if test="${empty dogNewborn.kinBreed}">
						<font>否</font>
					</c:if>
					<c:if test="${not empty dogNewborn.kinBreed}">
						<font color="red">是</font>
					</c:if>
				</td>
				<td>
				    <c:if test="${dogNewborn.paymentState==1}">
				        <font color="red">${fns:getDictLabel(dogNewborn.paymentState, 'user_payment_state', '')}&nbsp;${dogNewborn.price}</font>
				    </c:if>
				    <c:if test="${dogNewborn.paymentState!=1}">
                        <font color="green">${fns:getDictLabel(dogNewborn.paymentState, 'user_payment_state', '')}&nbsp;${dogNewborn.price}</font>
                    </c:if>
                    
                </td>
                <td title="${fns:escapeHtml(dogNewborn.reviewRemarks)}">
				       ${fns:getDictLabel(dogNewborn.reviewState, 'review_state', '')}
				</td>
				<td>
				    <a href="${ctxDc}/dogNewborn/form?id=${dogNewborn.id}">查看</a>

				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>