<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只鉴定添加</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            /* $("#stickerFlagChooseDiv").hide(); */
            //悬浮提示插件
            $(document).tooltip();
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
					$("#btnSubmit").attr("disabled" , "disabled");
                    loading('正在提交，请稍等...');
                    form.submit();
					$("#btnSubmit").remove("disabled");
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
        /* function stickerFlagChoose() {
            var stickerFlag = $("input[name='stickerFlag']:checked").val();
            if (stickerFlag == 1) {
                $("#stickerFlagChooseDiv").show();
            } else {
                $("#stickerFlagChooseDiv").hide();
            }
        } */
        function searchUser() {
            var memberCode = $("#dogOwnerCode").val();
            if (memberCode == '') {
                $.jBox.alert("请输入会员号!");
                return false;
            }
            $.ajax({
                type: "POST",
                url: "${ctxPartner}/clubMember/search",
                data: {'memberCode': memberCode , 'checkSingle':1},
                dataType: 'json',
                async: false,
                success: function (jsons) {
                    if (jsons.rc == 1) {
                        alert(jsons.msg);
                    } else {
                        $("#name").show();
                        $("#name").text(jsons.name);
                    }
                }
            });
        }

        function getDogColorMarkByDogBreed() {
            var dogBreedCode = $("#dogBreed").val();
            $.post('${ctxPartner}/dog/dogColorMark/getByDogBreed', {
                dogBreedCode: dogBreedCode
            }, function (data) {
                $('#dogFurColor').empty();
                var firstVal = '';
                $.each(data, function (i, val) {
                    $('#dogFurColor').append("<option value ='" + val.dogColorMarkCode + "'>" + val.dogColorMarkCn + "</option>");
                    if (i == 0) {
                        firstVal = val;
                    }
                });
                $('#dogFurColor').select2().val(firstVal).trigger("change");
            });
        }

        function check() {
//            console.log("start");
            var dogName = $('#dogName').val().trim();
            var dogBreed = $('#dogBreed').val();
            var dogFurColor = $('#dogFurColor').val();
            var dogGender = $('#dogGender').val();
            var birthday = $('#birthday').val();
            var memberCode = $('#dogOwnerCode').val().trim();
            var name = $('#name').text();
            if (dogName == '') {
                alert("犬名为空!");
                return false;
            }
            if (dogBreed == '') {
                alert("犬种为空!");
                return false;
            }
            if (dogFurColor == '') {
                alert("毛色为空!");
                return false;
            }
            if (dogGender == '') {
                alert("性别为空!");
                return false;
            }
            if (birthday == '') {
                alert("出生日期为空!");
                return false;
            }
            if (dogBreed == '') {
                alert("犬种为空!");
                return false;
            }
            if (memberCode == '' || name == '') {
                alert("犬主会员号为空,并点击查询按钮验证!");
                return false;
            }
            $("#inputForm").submit();
        }

        function clickHint(obj) {
            if (obj.value == 1) {
                alertx('犬只体内本身有芯片，请用扫描仪扫描确认芯片号码，确认无误后将此号码填写到相应位置');
            } else {
                alertx('犬只体内本身无芯片，请用扫描仪扫描确认无误后，埋置CKU芯片，并将CKU芯片号码填写到相应位置');
            }
        }
    </script>
    <!-- 悬浮提示插件 -->
    <link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctxPartner}/dog/appraisal/${dogAppraisal.dogBreed=='230'?'list?dogBreed=230':''}">犬只鉴定列表</a></li>
    <li class="active"><a href="${ctxPartner}/dog/appraisal/addForm?id=${dogAppraisal.id}">犬只鉴定添加</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="dogAppraisal" action="${ctxPartner}/dog/appraisal/add" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group" id="mainShowIdDiv">
        <label class="control-label">俱乐部：</label>
        <div class="controls">
                ${org.name}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬名：</label>
        <div class="controls">
            <form:input path="dogName" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬种：</label>
        <div class="controls">
            <form:select path="dogBreed" class="input-xlarge required" onchange="getDogColorMarkByDogBreed()">
                <form:options items="${dogTypeList}" itemLabel="breedEnName" itemValue="dogBreedCode"
                              htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">毛色：</label>
        <div class="controls">
            <form:select id="dogFurColor" path="dogFurColor" class="input-xlarge required">
                <form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode"
                              htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">性别：</label>
        <div class="controls">
            <form:radiobuttons path="dogGender" items="${fns:getDictList('dog_gender')}" itemLabel="label"
                               itemValue="value" htmlEscape="false" class="required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">出生日期：</label>
        <div class="controls">
            <input id="birthday" name="birthday" type="text" readonly="readonly" maxlength="20"
                   class="input-medium Wdate required"
                   value="<fmt:formatDate value="${dogAppraisal.birthday}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">会员号：</label>
        <div class="controls">
            <form:input path="dogOwnerCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
            <input id="selectMember" class="btn btn-primary" value="查询" type="button" onclick="searchUser()"/>
            <font color="red" id="name"></font>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">审核状态：</label>
        <div class="controls">
            <form:select id="reviewState" path="reviewState" class="input-xlarge required">
                <form:options items="${reviewList}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">有无芯片：</label>
        <div class="controls">
            <form:radiobuttons path="chipInject" items="${fns:getDictList('yes_no')}" itemLabel="label"
                               onclick="clickHint(this)" itemValue="value" htmlEscape="false" class="required"/>
        </div>
    </div>
<!--     <div class="control-group"> -->
<!--         <div class="controls"> -->
<!--             <input name="stickerFlag" type="checkbox" value="1" onclick="stickerFlagChoose()"/>宠爱护照及犬只等级申请 -->
<!--         </div> -->
<!--         <div class="controls" id="stickerFlagChooseDiv"> -->
<!--             <p>1、办理业务的同时为该犬只办理宠爱护照，并获得相应的犬只等级。</p> -->
<!--             <p>2、犬只等级申请后可在电子出生纸及电子证书中体现。</p> -->
<!--             <p>3、申请宠爱护照及犬只等级升级不额外加收费用。</p> -->
<!--         </div> -->
<!--     </div> -->

    <div class="form-actions">
        <input id="btnSubmit" class="btn btn-primary" type="button" onclick="check()" value="保 存"/>&nbsp;
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>