<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>统计管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/tongjis/caiwu/">统计列表</a></li>
		<shiro:hasPermission name="tongjis:caiwu:edit"><li><a href="${ctx}/tongjis/caiwu/form">统计添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="caiwu" action="${ctx}/tongjis/caiwu/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>yiji：</label>
				<form:input path="yiji" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>erji：</label>
				<form:input path="erji" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>sanji：</label>
				<form:input path="sanji" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>sanjiid：</label>
				<form:input path="sanjiid" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>type：</label>
				<form:input path="type" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<shiro:hasPermission name="tongjis:caiwu:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="caiwu">
			<tr>
				<shiro:hasPermission name="tongjis:caiwu:edit"><td>
    				<a href="${ctx}/tongjis/caiwu/form?id=${caiwu.id}">修改</a>
					<a href="${ctx}/tongjis/caiwu/delete?id=${caiwu.id}" onclick="return confirmx('确认要删除该统计吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>