<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员详情</title>
	<meta name="decorator" content="default"/>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
		<sys:message content="${message}"/>	
		<h3>会员基本信息</h3>
		<div class="control-group" style="width:80%">
			<label class="control-label">证件照：</label> 
			<div class="controls">
				<img alt="证件照" style="max-width:200px;" src="${ctx }/sys/file/image/${member.avatar }">
			</div>
		</div>
		<div style="clear:both;"></div>
		<div class="control-group">
			<label class="control-label">会员编号：</label>
			<div class="controls">
				<input id="memberCode" name="memberCode" type="text" readonly="readonly" value="${member.memberCode}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<input id="name" name="name" type="text" readonly="readonly" value="${member.name}"  maxlength="100" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名拼音：</label>
			<div class="controls">
				<input  name="nameEn" type="text" readonly="readonly" value="${member.nameEn}"  maxlength="100" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<input id="gender" name="gender" type="text" readonly="readonly" value="${fns:getDictLabels(member.gender, 'user_gender', '')}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.birthday}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件号：</label>
			<div class="controls">
				<input id="cardNo" name="cardNo" type="text" readonly="readonly" value="${member.cardNo}"  maxlength="50" class="input-xlarge required" />
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">手机：</label>
			<div class="controls">
				<input name="mobile" type="text"  value="${member.mobile}" maxlength="200" class="input-xlarge required" readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮编：</label>
			<div class="controls">
				<input name="postcode" type="text" value="${member.postcode}" maxlength="60" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">QQ：</label>
			<div class="controls">
				<input name="qq" type="text" value="${member.qq}" maxlength="50" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">固定电话：</label>
			<div class="controls">
				<input name="phone" type="text" value="${member.phone}"  maxlength="200" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">传真：</label>
			<div class="controls">
				<input name="fax" type="text" value="${member.fax}"  maxlength="200" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮箱：</label>
			<div class="controls">
				<input name="email" type="text" value="${member.email}" maxlength="200" class="input-xlarge email" readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				${member.province }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				${member.city }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<input name="street" type="text" maxlength="200" class="input-xlarge " readonly="readonly" value="${member.street}"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">账户余额：</label>
			<div class="controls">
				${ member.accountBalance}
			</div>
		</div>
		
		<div style="clear:both;"></div>
		<h3>会员缴费信息</h3>
		<div class="control-group">
			<label class="control-label">会员类型：</label>
			<div class="controls">
				<input name="memberType" type="text" maxlength="200" class="input-xlarge " readonly="readonly" value="${fns:getDictLabels(member.memberType,'user_member_type','')}"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费状态：</label>
			<div class="controls">
				<input type="text" value="${fns:getDictLabels(member.paymentState, 'user_payment_state', '未缴费')}" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">第一次缴费时间：</label>
			<div class="controls">
				<fmt:formatDate value="${member.firstPaymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员截止时间：</label>
			<div class="controls">
				<input name="" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.memberEndDate}" pattern="yyyy-MM-dd"/>"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">美容师类型：</label>
			<div class="controls">
				${fns:getDictLabels(member.groomerType, 'groomer_type', '非会员')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">美容师结束时间：</label>
			<div class="controls">
				<input name="" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.groomerEndDate}"  pattern="yyyy-MM-dd"/>"/>

			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬运动会员类型：</label>
			<div class="controls">
				${fns:getDictLabels(member.dgMemberType, 'dg_member_type', '非会员')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬运动会员过期时间：</label>
			<div class="controls">
				<input type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.dgEndDate}" pattern="yyyy-MM-dd"/>"/>
					
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>其他信息</h3>
		<div class="control-group">
			<label class="control-label">推荐人会员号：</label>
			<div class="controls">
				<input name="referee" type="text" maxlength="200" class="input-xlarge " readonly="readonly" value="${member.referee}"/>
			</div>
		</div>
		
		 
		<div class="control-group">
			<label class="control-label">证书邮寄方式：</label>
			<div class="controls">
				<input  value="${member.deliveryCertified }" type="text"  maxlength="255" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">通知邮寄方式：</label>
			<div class="controls">
				<input  value="${member.deliveryNotice }" type="text"  maxlength="255" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">最后联系时间：</label>
			<div class="controls">
				<input name="lastCall" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.lastCall}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">禁止报名截至时间：</label>
			<div class="controls">
				<input name="banEndDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.banEndDate}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
			<input  value="${member.remarks }" type="text"  maxlength="255" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">所属俱乐部：</label>
			<div class="controls">
			<input  value="${member.ckuClub }" type="text"  maxlength="255" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
</body>
</html>