<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>FCI资格证书编辑</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">

		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function (form) {
					var reviewerFlag = false;
					var dogCategoryFlag = false;
					var referee = $('#referee').val();
					var showRefereeList = '${fns:escapeEcmaScript(showRefereeList)}';
					var reviewerArray = referee.split(";");
					$.each(reviewerArray, function(i,val) {
						if (!showRefereeList.includes(val)) {
							alert("该审查员： " + val + "不存在！");
							reviewerFlag = true;
							return false;
						}
					});
					if (reviewerFlag) {
						return;
					}
					var dogCategory = $('#dogCategory').val();
					var dogCateGoryNames = '${fns:escapeEcmaScript(dogCateGoryNames)}';
					var dogCategoryArray = dogCategory.split(";");
					$.each(dogCategoryArray, function(i,val) {
						if (!dogCateGoryNames.includes(val)) {
							alert("该犬种类别： " + val + "不存在，请核对！");
							dogCategoryFlag = true;
							return false;
						}
					});
					if (dogCategoryFlag) {
						return;
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function (error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			/*$('#reviewer').blur(function() {
				/!*var showRefereeList = '${fns:escapeHtml(showRefereeList)}';
				var eval1 = eval(showRefereeList);
				var $reviewer = $("#reviewer");
				var reviewerArray = $reviewer.split(";");
				$.each(reviewerArray, function(i,val) {
					if (!eval1.includes(val)) {
						alert("该审查员： " + val + "不存在！");
					}
				});*!/
				alert("111111")
			});*/

			/*$('#inputForm').on('submit', function(e) {


				// 如果验证通过，则继续提交表单
				// 如果需要，可以在这里执行其他逻辑，例如表单提交前的数据处理
			});*/
			/*//回显裁判信息
			var reviewer = '${fns:escapeHtml(groomerQualificationCertificate.reviewer)}';
			var refereeArray = reviewer.split(",");
			$.each(refereeArray, function(i,val) {
				$("#reviewer").find("option[value='"+val+"']").attr("selected",true);
			});
			$("#reviewer").trigger("change");*/

			/*$("#levelEn").change(function(){
				$("#levelCn").val($.trim($("#levelEn option:selected").text()));
			});*/
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li>
			<c:if test="${groomerQualificationCertificate.certificateType==1}"><a href="${ctx}/groomer/groomerQualificationCertificate/list">美容资格证书列表</a></c:if>
			<c:if test="${groomerQualificationCertificate.certificateType==2}"><a href="${ctx}/groomer/groomerQualificationCertificate/internationalList">国际宠物美容师证书列表</a></c:if>
			<c:if test="${groomerQualificationCertificate.certificateType==3}"><a href="${ctx}/groomer/groomerQualificationCertificate/petList">宠物造型师证书列表</a></c:if>
		</li>
		<li class="active">

			<c:if test="${groomerQualificationCertificate.certificateType==1}"><a href="${ctx}/groomer/groomerQualificationCertificate/form?id=${groomerQualificationCertificate.id}">美容资格证书编辑</a></c:if>
			<c:if test="${groomerQualificationCertificate.certificateType==2}"><a href="${ctx}/groomer/groomerQualificationCertificate/form?id=${groomerQualificationCertificate.id}">国际宠物美容师证书编辑</a></c:if>
			<c:if test="${groomerQualificationCertificate.certificateType==3}"><a href="${ctx}/groomer/groomerQualificationCertificate/form?id=${groomerQualificationCertificate.id}">宠物造型师证书编辑</a></c:if>

		</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="fciGroomerQualificationCertificate" action="${ctx}/groomer/fciGroomerQualificationCertificate/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" readonly="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<input id="name" type="text"  value="${fciGroomerQualificationCertificate.member.name}" readonly="true"  class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">取证日期：</label>
			<div class="controls">
				<input name="takeCertificateDate" type="text" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${fciGroomerQualificationCertificate.takeCertificateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<%--<div class="control-group">
			<label class="control-label">证书编号：</label>
			<div class="controls">
				<form:input path="fciCertificateCode"  htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>--%>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
				<form:select path="levelEn" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:option value="A" label="A"/>
					<form:option value="B" label="B"/>
					<form:option value="C" label="C"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">签发日期：</label>
			<div class="controls">
				<input name="issueDate" type="text"  maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${fciGroomerQualificationCertificate.issueDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员：</label>
			<div class="controls">
				<form:input path="referee" id="referee" htmlEscape="false" maxlength="100" class="input-xlarge"/>
				<font color="#FF0000" style="margin-left: 10px;">注：多个审查员之间要用英文分号做分割！！！例:张三;李四 </font>
			</div>
		</div>
		<%--<div class="control-group">
			<label class="control-label">审查员：</label>
			<div class="controls">
				<form:select path="reviewer" class="input-xlarge" multiple="true" style="width: 284px;">
					<form:options items="${showRefereeList}" itemLabel="refereeNameCn" itemValue="id" htmlEscape="false"/>
				</form:select>
				<font color="#FF0000" style="margin-left: 10px;">注：可以多选裁判！ </font>
			</div>
		</div>--%>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<c:if test="${empty fciGroomerQualificationCertificate.registerId}">
			<div class="control-group">
				<label class="control-label">犬种名称：</label>
				<div class="controls">
					<form:input path="dogCategory" id="dogCategory" htmlEscape="false" maxlength="100" class="input-xlarge"/>
					<font color="#FF0000" style="margin-left: 10px;">注：(历史数据问题提供的修改操作)多个犬种名称之间要用英文分号做分割！！！例:AAA;BBB </font>
				</div>
			</div>
		</c:if>
		<div class="form-actions">
			<shiro:hasPermission name="groomer:fciGroomerQualificationCertificate:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>