<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>财务收入</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.mouseOver{
			cursor:pointer;
		}
		.mouseOut{

		}
	</style>
	<script type="text/javascript">
        function mySubmit()
        {
            document.getElementById("isOnSubmit").value = "1";
            document.getElementById("searchForm").submit();
        }

        function SubmitByDate(date)
        {
            document.getElementById("isOnSubmit").value = "1";
            document.getElementById("nowDate").value=date;
            document.getElementById("searchForm").submit();
        }

        var ctx = "${ctx}";

        function toDetail(type)
        {
            var paymentTimeStart = $("#startDate").val();
            var paymentTimeEnd = $("#endDate").val();
            window.location.href=ctx+'/finance/memberAccount/?paymentWay='+type+'&paymentTimeStart='+paymentTimeStart+'&paymentTimeEnd='+paymentTimeEnd;
        }

        function toOnAccount()
        {
            var startAddTime = $("#startDate").val();
            var endAddTime = $("#endDate").val();
            window.location.href=ctx+'/finance/paymentOnAccount/?startAddTime='+startAddTime+'&endAddTime='+endAddTime;
        }

	</script>
</head>
<body>
<ul class="nav nav-tabs">
	<li class="active"><a href="#">财务收入</a></li>
	<li class=""><a href="${ctx}/finance/statistics/charge">业务扣费</a></li>
	<li class=""><a href="${ctx}/finance/statistics/orderList">业务扣费明细</a></li>
</ul>
<form id="searchForm"  action="${ctx}/finance/statistics/revenue" method="post" class="breadcrumb form-search">
	<ul class="ul-form">
		<li class="btns"><input id="btnSubmit_current_month" class="btn btn-primary" type="button" value="本月" onclick="SubmitByDate('month')"/></li>
		<li class="btns"><input id="btnSubmit_current_yearh" class="btn btn-primary" type="button" value="本年" onclick="SubmitByDate('year')"/></li>
		<li><input id="nowDate" type="hidden" name="nowDate" value=""/></li>
		<li><input id="isOnSubmit" type="hidden" name="isOnSubmit" value=""/></li>
		<li><label>开始时间：</label>
			<input style="width:160px;" id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				   value="${startDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
		</li>
		<li><label style="width:100px;">结束时间：</label>
			<input style="width:160px;" id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				   value="${endDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
		</li>
		<li class="btns"><input id="btnSubmit" name="btnSubmit" class="btn btn-primary" type="submit" onclick = "mySubmit()" value="查询"/></li>
		<li class="clearfix"></li>
	</ul>
</form>
<hr style="align:center;height:2px;border:none;border-top:2px groove skyblue;" />
<p style="text-align:left;font-size:18px;line-height:30px;"><b style="color:#363f68;">各项收款统计</b></p>
<table id="classification" class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th style="width:40%">收入类型</th>
		<th style="width:60%">收入总计(元)</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('1')">支付宝充值</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.alipay}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td ><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('24')">微信支付</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.webchat}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td ><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('30')">通联支付</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.allinpay}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('2')">建行网银充值</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.CBC}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('6')">兴业银行充值</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.CIB}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('3')">现金缴纳</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.cash}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('23')">杭办现场收入</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.hangzhouScene}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('21')">比赛现场收入</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.scene}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('8')">巡回收入</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.tour}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('20')">财务往来</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.dealings}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toOnAccount()">资金挂账</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.payOnAccount}" maxFractionDigits="2"/> </td>
	</tr>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('28')">现场微信支付</a></td>
		<td><fmt:formatNumber type="currency" value="${classification.wechatscene}" maxFractionDigits="2"/> </td>
	</tr>
	</tbody>
</table>

<hr style="align:center;height:2px;border:none;border-top:2px groove skyblue;" />
<p style="text-align:left;font-size:18px;line-height:30px;"><b style="color:#363f68;">商城俱乐部收入统计</b></p>
<table class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th style="width:40%">收入类型</th>
		<th style="width:60%">收入总计(元)</th>
	</tr>
	</thead>
	<tbody>
	<c:forEach items="${e_mall}" var="e">
	<tr>
		<td>${fns:getDictLabels(e.paymentWay, 'payment_way', '')}</td>
		<td><fmt:formatNumber type="currency" value="${e.revenue}" maxFractionDigits="2"/></td>

		</c:forEach>

	</tbody>
</table>
<hr style="align:center;height:2px;border:none;border-top:2px groove skyblue;" />
<p style="text-align:right;font-size:18px;line-height:20px;"><b id="count" style="color:#363f68;">合计：<fmt:formatNumber type="currency" value="${countAll}" maxFractionDigits="2"/></b></p>
<hr style="align:center;height:2px;border:none;border-top:2px groove skyblue;" />
<table class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th style="width:40%">收入类型</th>
		<th style="width:60%">收入总计(元)</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td><a onmouseover="this.className='mouseOver'" onmouseout="this.className='mouseOut'" onclick="toDetail('9')">系统导入</a></td>
		<td><fmt:formatNumber type="currency" value="${classification['import']}" maxFractionDigits="2"/></td>
	</tr>
	</tbody>
</table>
</body>
</html>