<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只芯片会员锁定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dog/dogChipMemberLock/">犬只芯片会员锁定列表</a></li>
		<shiro:hasPermission name="dog:dogChipMemberLock:edit"><li><a href="${ctx}/dog/dogChipMemberLock/form">犬只芯片会员锁定添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogChipMemberLock" action="${ctx}/dog/dogChipMemberLock/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>芯片号：</label>
				<form:input path="identificationFlag" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>是否锁定：</label>
				<form:select path="lockState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>会员姓名</th>
				<th>省</th>
				<th>市</th>
				<th>区</th>
				<th>地址</th>
				<th>芯片号</th>
				<th>犬种</th>
				<th>是否锁定</th>
				<shiro:hasPermission name="dog:dogChipMemberLock:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogChipMemberLock">
			<tr>
				<td>
					${dogChipMemberLock.memberCode}
				</td>
				<td>
					${dogChipMemberLock.memberName}
				</td>
				<td>
					${dogChipMemberLock.province}
				</td>
				<td>
					${dogChipMemberLock.city}
				</td>
				<td>
					${dogChipMemberLock.area}
				</td>
				<td>
					${dogChipMemberLock.street}
				</td>
				<td>
					${dogChipMemberLock.identificationFlag}
				</td>
				<td>
					${dogChipMemberLock.dogBreed}
				</td>
				<td>
					${fns:getDictLabel(dogChipMemberLock.lockState, 'yes_no', '')}
				</td>
				<shiro:hasPermission name="dog:dogChipMemberLock:edit"><td>
    				<a href="${ctx}/dog/dogChipMemberLock/form?id=${dogChipMemberLock.id}">修改</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>