<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>

</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/clubdog/clubDog/">淘宠犬只鉴定列表</a></li>
		<li class="active"><a href="${ctx}/clubdog/clubDog/form?id=${clubDog.id}">淘宠犬只鉴定<shiro:hasPermission name="clubdog:clubDog:edit">${not empty clubDog.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="clubdog:clubDog:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="clubDog" action="${ctx}/clubdog/clubDog/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:input path="pedigreeCertifiedCode" readonly="true" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-xlarge "/>
				<input id="search" class="btn btn-primary" type="button" value="查" onclick="searchUser(1)"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主人：</label>
			<div class="controls">
				<form:input path="dogOwner" readonly="true" htmlEscape="false"  maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">中文姓名：</label>
			<div class="controls">
				<form:input path="nameCn"  htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">英文姓名：</label>
			<div class="controls">
				<form:input path="nameEn"  htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:radiobuttons path="gender" items="${fns:getDictList('dog_gender')}" disabled="true" itemLabel="label" itemValue="value" htmlEscape="false" class=""/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">种类：</label>
			<div class="controls">
                <form:select id="dogBreed" path="dogBreed" class="input-xlarge" >
                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" disabled="true" htmlEscape="false"/>
                </form:select>			
             </div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthdate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${clubDog.birthdate}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片号：</label>
			<div class="controls">
				<form:input path="identificationFlag" readonly="true" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">毛色：</label>
			<div class="controls">
				<form:select id="colorFlag" path="colorFlag" class="input-xlarge">
                    <form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" disabled="true" htmlEscape="false"/>
                </form:select>			
             </div>
		</div>
		<div class="control-group">
			<label class="control-label">鉴定人：</label>
			<div class="controls">
				<form:input path="identifyer" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">鉴定编号：</label>
			<div class="controls">
				<form:input path="identifyCode" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">支付状态：</label>
			<div class="controls">
				<form:select path="paymentState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" disabled="true" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">支付时间：</label>
			<div class="controls">
				<input name="paymentTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${clubDog.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" disabled="true" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核时间：</label>
			<div class="controls">
				<input name="reviewTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${clubDog.reviewTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核备注：</label>
			<div class="controls">
				<form:input path="reviewRemarks" readonly="true" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">处理状态：</label>
			<div class="controls">
				<form:select path="processState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('proccess_state')}" disabled="true" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">处理时间：</label>
			<div class="controls">
				<input name="processTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${clubDog.processTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">操作记录：</label>
			<div class="controls">
				<form:input path="operator" htmlEscape="false" maxlength="1000" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">流水号：</label>
			<div class="controls">
				<form:input path="runningNumber" readonly="true" htmlEscape="false" maxlength="1000" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions" style="float:left;width: 84%">
			<shiro:hasPermission name="clubdog:clubDog:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script type="text/javascript">
	//打开查询用户的弹窗
    var searchUserFlag = "";
    function searchUser(index){
        searchUserFlag = index;
        top.layer.open({
            type: 2,
            title: ['会员查询', 'font-size:18px;text-align: center;'],
            shadeClose: false,
            shade: [0.8, '#393D49'],
            maxmin: false, //开启最大化最小化按钮
            area: ['700px', '500px'],
            content: "${ctx}/sys/user/member/search"
        });
    }
    
   //查询用户完成的回调方法
   this.searchUserCallback = function (json){
       if(searchUserFlag=="1"){
           $("#memberCode").val(json.memberCode);
           $("#dogOwner").val(json.name);
       }
   }
	</script>
</body>
</html>