<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>轮播图管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    if ($("#img").val() == '') {
                        alert("请上传背景图片");
                        return 0;
                    }
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

            //下拉回显
            $("#type").val("${banner.type}");
            $("#type").trigger("change");
            $("#visibleFlag").val("${banner.visibleFlag}");
            $("#visibleFlag").trigger("change");

        });

    </script>
    <link href="${ctxStatic}/layui/css/layui.css" type="text/css" rel="stylesheet"/>
    <script src="${ctxStatic}/layui/layui.all.js" type="text/javascript"></script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/breeder/banner/">轮播图列表</a></li>
    <li class="active"><a href="${ctx}/breeder/banner/form?id=${banner.id}">轮播图<shiro:hasPermission
            name="breeder:banner:edit">${not empty banner.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission
            name="breeder:banner:edit">查看</shiro:lacksPermission></a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="banner" action="${ctx}/breeder/banner/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">模块：</label>
        <div class="controls">
            <form:input path="module" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">标题：</label>
        <div class="controls">
            <form:input path="title" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">背景图片：</label>
        <div class="controls">
            <sys:singleImgUpload module="breedBanner" imgId="${banner.img}" state="1" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
            <form:input path="img" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
            <!-- 文件上传成功的回调方法 -->
            <script type="text/javascript">
                function uploadSuccess(file,response){
                    $("#img").val(response.id);
                }
            </script>
            图片尺寸:<span class="help-inline" id="imgSize"> 图片类型支持jpg,png,大小限制在1M以内,传直角图片即可</span>
            <span id="imgSpan" class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">跳转地址：</label>
        <div class="controls">
            <form:textarea path="url" htmlEscape="false" rows="2" maxlength="300" class="input-xxlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">跳转类型：</label>
        <div class="controls">
            <form:select path="type" class="input-medium" onclick="clickFuc()">
                <option value="0">URL跳转</option>
                <option value="1">小程序跳转</option>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>

    <div class="control-group">
        <label class="control-label">小程序Id：</label>
        <div class="controls">
            <form:input path="programId" htmlEscape="false" maxlength="100" class="input-xlarge"/>
        </div>
    </div>

    <div class="control-group">
        <label class="control-label">是否可见：</label>
        <div class="controls">
            <form:select path="visibleFlag" class="input-medium">
                <option value="1">可见</option>
                <option value="0">不可见</option>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">显示开始时间：</label>
        <div class="controls">
            <input name="startTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
                   value="<fmt:formatDate value="${banner.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">显示结束时间：</label>
        <div class="controls">
            <input name="endTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
                   value="<fmt:formatDate value="${banner.endTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">排序：</label>
        <div class="controls">
            <form:input path="sort" htmlEscape="false" type="number" min="0" maxlength="5" class="input-xlarge required"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注信息：</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="1024" class="input-xxlarge "/>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="breeder:banner:edit"><input id="btnSubmit" class="btn btn-primary" type="submit"
                                                               value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>