/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.shop.model;

import java.util.Arrays;

import net.sf.json.JSONArray;

import org.apache.commons.lang.StringUtils;

/**
 * 商品管理Entity
 * 
 * @author lyy
 * @version 2016-08-11
 */
public class RestShopGoods {
	private String id;
	private String classId; // 商品分类主键
	private String className; // 商品分类名称
	private String code; // 商品编号
	private String name; // 商品名称
	private String image; // 商品展示图
	private JSONArray imageList = new JSONArray(); // 商品展现图list
	private String price; // 商品单价
	private String buyGifts; // 买赠
	private String isRebate; // 返利
	private String isFreight; // 运费
	private String weight; // 重量
	private String title; // 标题
	private String tag; // 标签
	private String details; // 商品详细
	private String isShelves; // 上架
	private String limits; // 限购
	private String num; // 数量
	private String saleNum; // 销售数量
	private String commentNum; // 评论数量
	private String addTime; // 添加时间

	private String isInterval;		// 是否有分区
	private String interval1Num;		// 分区1数量
	private String interval1Price;  // 分区1价格
	private String interval2Num;		// 分区2数量
	private String interval2Price;  // 分区2价格
	private String interval3Price;  // 分区3价格

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getClassId() {
		return classId;
	}

	public void setClassId(String classId) {
		this.classId = classId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		if (!StringUtils.isEmpty(image)) {
			if (StringUtils.contains(image, ",")) {
				for (String i : Arrays.asList(image.split(","))) {
					imageList.add(i);
				}
			} else {
				imageList.add(image);
			}
		}
		this.image = image;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public String getBuyGifts() {
		return buyGifts;
	}

	public void setBuyGifts(String buyGifts) {
		this.buyGifts = buyGifts;
	}

	public String getIsRebate() {
		return isRebate;
	}

	public void setIsRebate(String isRebate) {
		this.isRebate = isRebate;
	}

	public String getIsFreight() {
		return isFreight;
	}

	public void setIsFreight(String isFreight) {
		this.isFreight = isFreight;
	}

	public String getWeight() {
		return weight;
	}

	public void setWeight(String weight) {
		this.weight = weight;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}

	public String getIsShelves() {
		return isShelves;
	}

	public void setIsShelves(String isShelves) {
		this.isShelves = isShelves;
	}

	public String getLimits() {
		return limits;
	}

	public void setLimits(String limits) {
		this.limits = limits;
	}

	public String getNum() {
		return num;
	}

	public void setNum(String num) {
		this.num = num;
	}

	public String getSaleNum() {
		return saleNum;
	}

	public void setSaleNum(String saleNum) {
		this.saleNum = saleNum;
	}

	public String getCommentNum() {
		return commentNum;
	}

	public void setCommentNum(String commentNum) {
		this.commentNum = commentNum;
	}

	public String getAddTime() {
		return addTime;
	}

	public void setAddTime(String addTime) {
		this.addTime = addTime;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public JSONArray getImageList() {
		return imageList;
	}

	public String getIsInterval() {
		return isInterval;
	}

	public void setIsInterval(String isInterval) {
		this.isInterval = isInterval;
	}

	public String getInterval1Num() {
		return interval1Num;
	}

	public void setInterval1Num(String interval1Num) {
		this.interval1Num = interval1Num;
	}

	public String getInterval1Price() {
		return interval1Price;
	}

	public void setInterval1Price(String interval1Price) {
		this.interval1Price = interval1Price;
	}

	public String getInterval2Num() {
		return interval2Num;
	}

	public void setInterval2Num(String interval2Num) {
		this.interval2Num = interval2Num;
	}

	public String getInterval2Price() {
		return interval2Price;
	}

	public void setInterval2Price(String interval2Price) {
		this.interval2Price = interval2Price;
	}

	public String getInterval3Price() {
		return interval3Price;
	}

	public void setInterval3Price(String interval3Price) {
		this.interval3Price = interval3Price;
	}
}