package com.cku.restful.v1.open;

import com.cku.core.ListResultDto;
import com.cku.core.PageResultDto;
import com.cku.core.ResultDto;
import com.cku.oa.dog.entity.DogNoseMock;
import com.cku.oa.dog.service.DogNoseMockService;
import com.cku.restful.v1.open.request.DogNoseMockAddRequest;
import com.cku.restful.v1.open.request.DogNoseMockPageRequest;
import com.cku.restful.v1.open.response.DogNoseMockResp;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.beanvalidator.BeanValidators;
import com.thinkgem.jeesite.common.persistence.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 鼻纹模拟
 *
 * @author lintao
 * @version 2019-08-16
 */

@Controller
@Api(tags = "模拟鼻纹")
@RequestMapping(value = "/api/v1/open/dogNose/mock")
public class OpenDogNoseMockController extends BaseRestController {

	@Autowired
	private DogNoseMockService dogNoseMockService;

	@ApiOperation(value = "列表")
	@GetMapping(value = "/list")
	@ResponseBody
	public PageResultDto<DogNoseMockResp> findPage(@Valid DogNoseMockPageRequest request) {
		BeanValidators.validateWithException(validator, request);
		Page<DogNoseMockResp> respPage = dogNoseMockService.findPage(request);
		return PageResultDto.success(respPage.getList(), respPage.getCount(), (long) respPage.getTotalPage());
	}

	@ApiOperation(value = "获取随机3条")
	@GetMapping(value = "/list/topThree")
	@ResponseBody
	public ListResultDto<DogNoseMockResp> findRandomThree() {
		List<DogNoseMock> mockList = dogNoseMockService.findRandomThree();
		return ListResultDto.success(mockList.stream()
				.map(mock -> {
					DogNoseMockResp resp = DogNoseMockResp.builder().build();
					BeanUtil.copyProperties(resp, mock, "yyyy-MM-dd");
					return resp;
				})
				.collect(Collectors.toList()));
	}

	@ApiOperation(value = "添加")
	@PostMapping(value = "")
	@ResponseBody
	public ResultDto<Boolean> add(@RequestBody DogNoseMockAddRequest request) {
		dogNoseMockService.add(request);
		return ResultDto.success(Boolean.TRUE);
	}
}