/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.groomer.model;

import com.cku.restful.v1.dog.model.BaseRefundDto;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 美容师报名表Entity
 * 
 * @author cxt
 * @version 2016-07-14
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class RestGroomerRegister extends BaseRefundDto {
	/**
	 * 
	 */
	private static final long serialVersionUID = 6943596145574862972L;
	private String id;
	private String showCode; // 赛事编号
	private String registerCode; // 报名序号
	private String memberCode; // 会员号
	private String name; // 姓名
	private String gender; // 性别
	private String mobile; // 手机
	private String showLevel; // 参赛级别
	private String schoolNameCn; // 培训机构
	private String fee; // 报名费
	private String grade; // 成绩
	private String gradeTime; // 成绩录入时间
	private String showDogBreed; // 比赛犬种
	private String showDogBreedExtra; // 比赛犬种-自填
	private String avatar; // 报名证件照
	private String paymentState;// 支付状态
	private RestGroomerShow restGroomerShow;// 美容活动
	private String reviewState; // 审核状态
	private String reviewRemarks; // 审核的意见
	private String createDate; // 创建时间
	// 附件属性 是否有退款或退款中
	private boolean businessRefundState;
	private String[] showTypeSpare;
	private String showCategory;//活动类别
	private String isFree;//0 免费 1收费
	private String certificateId;
	private String shortName;
	private Boolean isShowModel;
	
	private String levelCn;//证书级别

	/**
	 * 笔试分数(只做展示)
	 * @return
	 */
	private String writtenScore;

	/**
	 * 笔试成绩
	 */
	private String gradeWrite;

	/**
	 * 美容报名活动流程状态
	 */
	private Integer groomerQualificationStatus;

	/**
	 * 资格证书类型
	 */
	private Integer qualificationCertificateType;

	/**
	 * 新旧UI 开关type
	 * 对应 GroomerExamUIEnum枚举
	 */
	private Integer uiSwitchType = 0;
}