/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.groomer.dao.GroomerDiplomaDao;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.service.GroomerCourseService;
import com.cku.oa.groomer.utils.GroomerUtil;
import com.cku.oa.handler.dao.HandlerDiplomaDao;
import com.cku.oa.handler.dao.HandlerQualificationCertificateDao;
import com.cku.oa.handler.entity.HandlerDiploma;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.service.HandlerDiplomaService;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.dog.vo.PersonnelVO;
import com.cku.util.ServletUtils;
import com.google.common.collect.Ordering;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
* @Description:  app 人才查询
* @author: zhangxiang
* @date: 2020/8/4 17:25
*/
@Service
@Transactional(readOnly = true)
public class RestPersonnelService {

	@Autowired
	private GroomerQualificationCertificateDao groomerQualificationCertificateDao;
	@Autowired
	private GroomerDiplomaDao groomerDiplomaDao;
	@Autowired
	private HandlerQualificationCertificateDao handlerQualificationCertificateDao;
	@Autowired
	private HandlerDiplomaDao handlerDiplomaDao;
	@Autowired
	private MemberService memberService;
	@Autowired
	private GroomerCourseService groomerCourseService;
	@Autowired
	private OrgDao orgDao;
    @Autowired
    private HandlerDiplomaService handlerDiplomaService;

	public RESTResponse getByKey(HttpServletRequest request) {
		//获取key
		String key = request.getParameter("key");
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "key为空");
		}
		List<Map<String, String>> msgList = new ArrayList<Map<String,String>>();

		List<GroomerQualificationCertificate> qualificationCertificates = groomerQualificationCertificateDao.getByKeyNew(key);
		if (CollectionUtils.isNotEmpty(qualificationCertificates)) {
			for (GroomerQualificationCertificate groomerQualificationCertificate : qualificationCertificates) {
				Map<String, String> map = new HashMap<String, String>();
				String certificateType = groomerQualificationCertificate.getCertificateType();
				if ("3".equals(certificateType)) {
					map.put("top", "宠物造型师资格证书");
				} else if ("2".equals(certificateType)) {
					map.put("top", "国际宠物美容师资格证书");
				} else if ("4".equals(certificateType)) {
					map.put("top", "CKU国际宠物洗护师");
				} else if ("1".equals(certificateType)) {
					map.put("top", "美容师资格证书");
				} else if ("6".equals(certificateType)) {
					map.put("top", "派多格资格证书");
				} else if ("7".equals(certificateType)) {
					map.put("top", "FCI美容师资格认证");
				} else if ("8".equals(certificateType)) {
					map.put("top", "伴侣猫洗护师资格证书");
				}
				map.put("memberCode", groomerQualificationCertificate.getMemberCode());
				map.put("name", groomerQualificationCertificate.getName());
				map.put("certificateCode", groomerQualificationCertificate.getCertificateCode());
				String levelCn = groomerQualificationCertificate.getLevelCn();
				map.put("level", levelCn);
				if(groomerQualificationCertificate.getIssueDate()!=null){
					map.put("issDate", DateUtils.formatDate(groomerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", null);
				msgList.add(map);
			}
		}
/*

		//美容资格证书
		List<GroomerQualificationCertificate> gqcList = groomerQualificationCertificateDao.getByKey(key);
		if(gqcList.size()>0){
			for (GroomerQualificationCertificate groomerQualificationCertificate : gqcList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "美容师资格证书");
				map.put("memberCode", groomerQualificationCertificate.getMemberCode());
				map.put("name", groomerQualificationCertificate.getName());
				map.put("certificateCode", groomerQualificationCertificate.getCertificateCode());
				String levelCn = groomerQualificationCertificate.getLevelCn();
				map.put("level", levelCn);
				if(groomerQualificationCertificate.getIssueDate()!=null){
					map.put("issDate", DateUtils.formatDate(groomerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", null);
				msgList.add(map);
			}
		}

		List<GroomerQualificationCertificate> gqcPartnerCatList = groomerQualificationCertificateDao.getByKey(key);
		if(gqcList.size()>0){
			for (GroomerQualificationCertificate groomerQualificationCertificate : gqcPartnerCatList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "伴侣猫洗护证书");
				map.put("memberCode", groomerQualificationCertificate.getMemberCode());
				map.put("name", groomerQualificationCertificate.getName());
				map.put("certificateCode", groomerQualificationCertificate.getCertificateCode());
				String levelEn = groomerQualificationCertificate.getLevelEn().trim();
				map.put("level", GroomerUtil.getCatNurseLevelCn(levelEn));
				if(groomerQualificationCertificate.getIssueDate()!=null){
					map.put("issDate", DateUtils.formatDate(groomerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", null);
				msgList.add(map);
			}
		}
		//国际宠物洗护师证书
		List<GroomerQualificationCertificate> gjxhsList = groomerQualificationCertificateDao.getNurseByKey(key);
		if(gjxhsList.size()>0){
			for (GroomerQualificationCertificate groomerQualificationCertificate : gjxhsList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "国际宠物洗护师证书");
				map.put("memberCode", groomerQualificationCertificate.getMemberCode());
				map.put("name", groomerQualificationCertificate.getName());
				map.put("certificateCode", groomerQualificationCertificate.getCertificateCode());
				map.put("level",GroomerUtil.getLevelCn(groomerQualificationCertificate.getLevelEn().trim()));
				if(groomerQualificationCertificate.getIssueDate()!=null){
					map.put("issDate", DateUtils.formatDate(groomerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", null);
				msgList.add(map);
			}
		}*/
		//美容结业证书
		List<GroomerDiploma> gdList = groomerDiplomaDao.getByKey(key);
		if(gdList.size()>0){
			for (GroomerDiploma groomerDiploma : gdList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "美容师结业证书");
				map.put("memberCode", groomerDiploma.getMemberCode());
				map.put("name", groomerDiploma.getName());
				map.put("level", groomerDiploma.getCertificateLevel());
				map.put("certificateCode", groomerDiploma.getCertificateCode());
				if(groomerDiploma.getIssueDate()!=null){
					map.put("issDate", DateUtils.formatDate(groomerDiploma.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", groomerDiploma.getSchoolNameCn());
				msgList.add(map);
			}
		}
		//牵犬师资格证书
		List<HandlerQualificationCertificate> hqcList = handlerQualificationCertificateDao.getByKey(key);
		if(hqcList.size()>0){
			for (HandlerQualificationCertificate handlerQualificationCertificate : hqcList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "牵犬师资格证书");
				map.put("memberCode", handlerQualificationCertificate.getMemberCode());
				map.put("name", handlerQualificationCertificate.getName());
				map.put("certificateCode", handlerQualificationCertificate.getCertificateCode());
				String levelEn = handlerQualificationCertificate.getCertificateLevelEn();
				if("MASTER".equals(levelEn.trim())){
					map.put("level", "教师级");
				}else{
					map.put("level", levelEn);
				}
				if(handlerQualificationCertificate.getIssueDate()!=null){
					map.put("issDate", DateUtils.formatDate(handlerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", null);
				msgList.add(map);
			}
		}
		// 训练师资格证书
		List<HandlerQualificationCertificate> hqcTrainerList = handlerQualificationCertificateDao.getHandlerTrainerByKey(key);
		if (hqcTrainerList.size() > 0) {
			for (HandlerQualificationCertificate handlerQualificationCertificate : hqcTrainerList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "训练师资格证书");
				map.put("memberCode", handlerQualificationCertificate.getMemberCode());
				map.put("name", handlerQualificationCertificate.getName());
				map.put("certificateCode", handlerQualificationCertificate.getCertificateCode());
				String levelEn = handlerQualificationCertificate.getCertificateLevelEn();
				if ("MASTER".equals(levelEn.trim())) {
					map.put("level", "教师级");
				} else {
					map.put("level", levelEn);
				}
				if (handlerQualificationCertificate.getIssueDate() != null) {
					map.put("issDate",
							DateUtils.formatDate(handlerQualificationCertificate.getIssueDate(), "yyyy-MM-dd"));
				}
				msgList.add(map);
			}
		}
		//牵犬师 结业证书
		List<HandlerDiploma> hdList = handlerDiplomaDao.getByKey(key,"0");
		if(hdList.size()>0){
			for (HandlerDiploma handlerDiploma : hdList) {
				Map<String, String> map = new HashMap<String, String>();
				map.put("top", "牵犬师结业证书");
				map.put("memberCode", handlerDiploma.getMemberCode());
				map.put("name", handlerDiploma.getName());
				map.put("level", handlerDiploma.getCertificateLevel());
				map.put("certificateCode", handlerDiploma.getCertificateCode());
				if(handlerDiploma.getIssueDate()!=null){
					map.put("issDate", DateUtils.formatDate(handlerDiploma.getIssueDate(), "yyyy-MM-dd"));
				}
				map.put("schoolName", handlerDiploma.getSchoolNameCn());
				msgList.add(map);
			}
		}
		return new RESTResponse("list",msgList);
	}

	/**
	 * app  人才招聘  美容师板块/牵犬师板块
	 * @param request
	 * @return
	 */
	public void findByMember(HttpServletRequest request, HttpServletResponse response)throws IOException {
		String type = request.getParameter("type");
		String city = request.getParameter("city");
		String level = request.getParameter("level");
		if(StringUtils.isNotBlank(level)){
            level = level.toUpperCase();
        }
		Member member = new Member();
		if(StringUtils.isNotBlank(city)){
			member.setCity(city);
		}
		List<String> str = Stream.of("MASTER","M", "A", "B", "C", "none",
				"国际高级宠物美容师","国际宠物美容师","宠物造型师","教师级","MATCH","SENIOR","PRIMARY").collect(Collectors.toList());
		Ordering ordering = Ordering.explicit(str);
		List<PersonnelVO> personnelVOList = new ArrayList<>();
		long count = 0;
		if("1".equals(type)){
			HandlerQualificationCertificate certificate = new HandlerQualificationCertificate();
			certificate.setCertificateLevelEn(level);
			certificate.setMember(member);
			//List<HandlerQualificationCertificate> list = handlerQualificationCertificateDao.getPersonnel(certificate);
			Page<HandlerQualificationCertificate> page = this.findPage(new Page<HandlerQualificationCertificate>(request, response), certificate);
			page.getList().forEach(e->{
				PersonnelVO personnelVO = new PersonnelVO();
				String certificateLevelEn = e.getCertificateLevelEn();
				if(StringUtils.isNotBlank(certificateLevelEn)){
					List<String> list1 = Arrays.asList(certificateLevelEn.split(","));
					Collections.sort(list1, new Comparator<String>() {
						@Override
						public int compare(String o1, String o2) {
							if(str.contains(o1) && str.contains(o2)){
								return ordering.compare(o1,o2);
							}else{
								return 0;
							}
						}
					});
					//去重复
					list1 = list1.stream().distinct().collect(Collectors.toList());
					personnelVO.setLevel(list1);
				}
				//防止没有会员数据
				if(e.getMember()!=null && null!=e.getMember().getMemberCode() && !"".equals(e.getMember().getMemberCode())){
				    if(StringUtils.isNotBlank(e.getMember().getAvatar())){
                        String path = request.getContextPath();
                        String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+e.getMember().getAvatar();
                        personnelVO.setAvatar(imgPath);
                    }
					personnelVO.setProvince(e.getMember().getProvince());
					personnelVO.setCity(e.getMember().getCity());
					personnelVO.setMemberCode(e.getMember().getMemberCode());
					personnelVO.setMobile(e.getMember().getMobile());
					personnelVO.setName(e.getMember().getName());
					personnelVO.setArea(e.getMember().getArea());
					personnelVO.setSchoolNameCn(null);
					personnelVOList.add(personnelVO);
				}
			});
			count = page.getCount();
		}else if("2".equals(type)){
			GroomerQualificationCertificate certificate = new GroomerQualificationCertificate();
			certificate.setLevelEn(level);
			certificate.setMember(member);
			Page<GroomerQualificationCertificate> page = this.findPage(new Page<GroomerQualificationCertificate>(request, response), certificate);
			page.getList().forEach(e->{
				PersonnelVO personnelVO = new PersonnelVO();
				String certificateLevelEn = e.getLevelEn();
				if(StringUtils.isNotBlank(certificateLevelEn)){
					List<String> list1 = Arrays.asList(certificateLevelEn.split(","));
					Collections.sort(list1, new Comparator<String>() {
						@Override
						public int compare(String o1, String o2) {
							if(str.contains(o1) && str.contains(o2)){
								return ordering.compare(o1,o2);
							}else{
								return 0;
							}
						}
					});
					//中英翻译
					list1 = list1.stream().map(a->GroomerUtil.getLevelCn(a)).collect(Collectors.toList());
					//保存等级
					personnelVO.setLevel(list1);
				}
				//防止没有会员数据
				if(e.getMember()!=null && null!=e.getMember().getMemberCode() && !"".equals(e.getMember().getMemberCode())){
                    if(StringUtils.isNotBlank(e.getMember().getAvatar())){
                        String path = request.getContextPath();
                        String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+e.getMember().getAvatar();
                        personnelVO.setAvatar(imgPath);
                    }
					personnelVO.setProvince(e.getMember().getProvince());
					personnelVO.setCity(e.getMember().getCity());
					personnelVO.setMemberCode(e.getMember().getMemberCode());
					personnelVO.setMobile(e.getMember().getMobile());
					personnelVO.setName(e.getMember().getName());
					personnelVO.setArea(e.getMember().getArea());
					personnelVO.setSchoolNameCn(null);
					personnelVOList.add(personnelVO);
				}
			});
			count = page.getCount();
		}else{
			//训犬
            Page<HandlerDiploma> page = handlerDiplomaService.findListApp(new Page<HandlerDiploma>(request, response),new HandlerDiploma());
            page.getList().forEach(e->{
                PersonnelVO personnelVO = new PersonnelVO();
                //防止没有会员数据
                if(e.getMember()!=null && null!=e.getMember().getMemberCode() && !"".equals(e.getMember().getMemberCode())){
                    if(StringUtils.isNotBlank(e.getMember().getAvatar())){
                        String path = request.getContextPath();
                        String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+e.getMember().getAvatar();
                        personnelVO.setAvatar(imgPath);
                    }
                    personnelVO.setProvince(e.getMember().getProvince());
                    personnelVO.setCity(e.getMember().getCity());
                    personnelVO.setMemberCode(e.getMember().getMemberCode());
                    personnelVO.setMobile(e.getMember().getMobile());
                    personnelVO.setName(e.getMember().getName());
                    personnelVO.setArea(e.getMember().getArea());
                    personnelVO.setSchoolNameCn(null);
                    personnelVOList.add(personnelVO);
                }
            });
            count = page.getCount();
        }

		ServletUtils.writeResponse(response, new RESTResponse("list",
				new PageBeanResult<PersonnelVO>(personnelVOList, count)));
	}



	public Page<HandlerQualificationCertificate> findPage(Page<HandlerQualificationCertificate> page, HandlerQualificationCertificate handlerQualificationCertificate) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		handlerQualificationCertificate.setPage(page);
		page.setList(handlerQualificationCertificateDao.getPersonnel(handlerQualificationCertificate));
		if((pageNo-1)*pageSize>=page.getCount()){
			page.setList(new ArrayList<HandlerQualificationCertificate>(0));
		}
		return page;
	}

	public Page<GroomerQualificationCertificate> findPage(Page<GroomerQualificationCertificate> page, GroomerQualificationCertificate groomerQualificationCertificate) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		groomerQualificationCertificate.setPage(page);
		page.setList(groomerQualificationCertificateDao.getPersonnel(groomerQualificationCertificate));
		if((pageNo-1)*pageSize>=page.getCount()){
			page.setList(new ArrayList<GroomerQualificationCertificate>(0));
		}
		return page;
	}


	public  Member getLoginMember() {
		User user = UserUtils.getLoginUser();
		if (user.getId() != null) {
			Member member = new Member();
			member.setUser(user);
			if("3".equals(user.getUserType())) {
				Org org = orgDao.findByUserId(user.getId());
				return memberService.getByMemberCode(org.getMemberCode());
			}else {
				List<Member> members = memberService.findList(member);

				if (members.size() != 0) {
					members.get(0).setLoginType(user.getLoginType());
					return member = members.get(0);
				}
			}

		}
		return null;
	}

	public Page<GroomerCourse>  groomerCourseOfflineList(GroomerCourse groomerCourse, HttpServletRequest request, HttpServletResponse response){
		//排序规则
		List<String> str = Stream.of("MASTER", "A", "B", "C", "none").collect(Collectors.toList());
		Ordering ordering = Ordering.explicit(str);
		//获取当前会员认证美容师
		GroomerQualificationCertificate certificate = new GroomerQualificationCertificate();
		Member loginMember = this.getLoginMember();
		List<String> levelOrderBy = new ArrayList<>();
		if(loginMember!=null){
			Member m = new Member();
			m.setMemberCode(loginMember.getMemberCode());
			certificate.setMember(m);
			List<GroomerQualificationCertificate> personnel = groomerQualificationCertificateDao.getPersonnel(certificate);
			personnel.stream().forEach(e->{
				String certificateLevelEn = e.getLevelEn();
				if(com.thinkgem.jeesite.common.utils.StringUtils.isNotBlank(certificateLevelEn)){
					List<String> list1 = Arrays.asList(certificateLevelEn.split(","));
					Collections.sort(list1, new Comparator<String>() {
						@Override
						public int compare(String o1, String o2) {
							if(str.contains(o1) && str.contains(o2)){
								return ordering.compare(o1,o2);
							}else{
								return 0;
							}
						}
					});
					e.setLevelEn(listToString(list1));
				}
			});

			//排序规则
			if(personnel.size()>0 &&  StringUtils.isNotBlank(personnel.get(0).getLevelEn())){
				GroomerQualificationCertificate groomerQualificationCertificate = personnel.get(0);
				List<String> level = Arrays.asList(groomerQualificationCertificate.getLevelEn().split(","));
				if("A".equals(level.get(0))){
					levelOrderBy.add("MASTER");
				}
				else if("B".equals(level.get(0))){
					levelOrderBy.add("A");
				}
				else if("C".equals(level.get(0))){
					levelOrderBy.add("B");
				}
				groomerCourse.setLevelOrderBy(levelOrderBy);
			}
		}
		groomerCourse.setType("1");
		return groomerCourseService.findPage(new Page<GroomerCourse>(request, response), groomerCourse);

	}
	public String listToString(List<String> list1){
		if(list1.size()>0){
			StringBuffer stringBuffer = new StringBuffer();
			for(int i=0;i<list1.size();i++){
				if(i==0){
					stringBuffer.append(list1.get(i));
				}else{
					stringBuffer.append(",").append(list1.get(i));
				}
			}
			return stringBuffer.toString();
		}else{
			return "";
		}
	}
}